/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.ide.core.search.SearchEngine;
import org.eclipse.edt.ide.ui.internal.search.EGLSearchMessages;
import org.eclipse.edt.ide.ui.internal.search.EGLSearchQuery;
import org.eclipse.edt.ide.ui.internal.search.EGLSearchScopeFactory;
import org.eclipse.edt.ide.ui.internal.search.SearchUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class EGLContextMenuSearchAction
extends Action {
    public static final int LIMIT_DECLARATIONS = 0;
    public static final int LIMIT_REFERENCES = 1;
    public static final int LIMIT_ALL_OCCURRENCES = 2;
    private Viewer viewer = null;
    private int iScope = 0;
    private int iLimitTo = 2;
    private IWorkingSet workingset = null;
    private Node[] eglParts = null;
    private IFile declaringFile = null;

    public EGLContextMenuSearchAction(Viewer viewer, int scope, int limit, String title, boolean enable, IFile file, Node[] parts) {
        super(title);
        this.viewer = viewer;
        this.iScope = scope;
        this.iLimitTo = limit;
        this.setEnabled(enable);
        this.eglParts = parts;
        this.declaringFile = file;
    }

    public EGLContextMenuSearchAction(Viewer viewer, int scope, int limit, IWorkingSet wset, String title, boolean enable, IFile file, Node[] parts) {
        this(viewer, scope, limit, title, enable, file, parts);
        this.workingset = wset;
    }

    public void run() {
        NewSearchUI.activateSearchResultView();
        IEGLSearchScope scope = null;
        String scopeDescription = "";
        if (this.eglParts != null) {
            scopeDescription = EGLSearchMessages.PartsScope;
            scope = SearchEngine.createEGLSearchScope((Node[])this.eglParts);
        } else {
            switch (this.iScope) {
                case 0: {
                    scopeDescription = EGLSearchMessages.WorkspaceScope;
                    scope = SearchEngine.createWorkspaceScope();
                    break;
                }
                case 3: {
                    IEGLElement[] projArray = new IEGLElement[1];
                    IProject project = this.declaringFile.getProject();
                    try {
                        if (project != null && project.isAccessible() && project.hasNature(EGLCore.NATURE_ID)) {
                            projArray[0] = EGLCore.create((IProject)project);
                        }
                    }
                    catch (CoreException coreException) {}
                    scope = SearchEngine.createEGLSearchScope((IEGLElement[])projArray);
                    IProject[] projects = EGLSearchScopeFactory.getInstance().getProjects(scope);
                    if (projects.length >= 1) {
                        if (projects.length == 1) {
                            scopeDescription = EGLSearchMessages.bind((String)EGLSearchMessages.EnclosingProjectScope, (Object)projects[0].getName());
                            break;
                        }
                        scopeDescription = EGLSearchMessages.bind((String)EGLSearchMessages.EnclosingProjectsScope, (Object)projects[0].getName());
                        break;
                    }
                    scopeDescription = EGLSearchMessages.bind((String)EGLSearchMessages.EnclosingProjectScope, (Object)"");
                    break;
                }
                case 2: {
                    IWorkingSet[] workingSets = null;
                    workingSets = this.workingset != null ? new IWorkingSet[]{this.workingset} : EGLSearchScopeFactory.getInstance().queryWorkingSets();
                    if (workingSets == null || workingSets.length < 1) {
                        return;
                    }
                    scopeDescription = EGLSearchMessages.bind((String)EGLSearchMessages.WorkingSetScope, (Object)SearchUtil.toString(workingSets));
                    scope = EGLSearchScopeFactory.getInstance().createEGLSearchScope(workingSets);
                }
            }
        }
        String pattern = this.getPackageName(this.declaringFile);
        if (pattern.length() > 0) {
            pattern = String.valueOf(pattern) + ".";
        }
        EGLSearchQuery wsJob = new EGLSearchQuery(pattern, false, 0, this.iLimitTo, scope, scopeDescription, true);
        NewSearchUI.runQueryInBackground((ISearchQuery)wsJob);
    }

    private String getPackageName(IFile file) {
        IEGLFile eglFile = (IEGLFile)EGLCore.create((IFile)file);
        IPackageFragment packageFragment = (IPackageFragment)eglFile.getAncestor(4);
        if (packageFragment.isDefaultPackage()) {
            return "";
        }
        String[] packageNameArray = packageFragment.getElementName().split("\\.");
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < packageNameArray.length) {
            if (i > 0) {
                buf.append(".");
            }
            buf.append(packageNameArray[i]);
            ++i;
        }
        return buf.toString();
    }

    private static void appendWorkingSets(IMenuManager menu, Viewer viewer, int limit, boolean bEnabled, IFile file) {
        IWorkingSet[] wsets = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
        int i = 0;
        while (i < wsets.length) {
            IWorkingSet wset = wsets[i];
            menu.add((IAction)new EGLContextMenuSearchAction(viewer, 2, limit, wset, wset.getName(), bEnabled, file, null));
            ++i;
        }
    }

    public static void appendToMenu(IMenuManager menu, Viewer viewer, IFile declaringFile, Node[] parts) {
        boolean bEnabled = false;
        MenuManager refMenu = new MenuManager(EGLSearchMessages.EGLSearchActionReference);
        refMenu.add((IAction)new EGLContextMenuSearchAction(viewer, 0, 1, EGLSearchMessages.EGLSearchActionWorkspace, bEnabled, declaringFile, null));
        refMenu.add((IAction)new EGLContextMenuSearchAction(viewer, 3, 1, EGLSearchMessages.EGLSearchActionProject, bEnabled && declaringFile != null, declaringFile, null));
        if (parts != null) {
            refMenu.add((IAction)new EGLContextMenuSearchAction(viewer, 3, 1, EGLSearchMessages.EGLSearchActionPartslist, bEnabled && parts != null, declaringFile, parts));
        }
        refMenu.add((IAction)new EGLContextMenuSearchAction(viewer, 2, 1, EGLSearchMessages.EGLSearchActionWorkingset, bEnabled, declaringFile, null));
        refMenu.add((IContributionItem)new Separator());
        EGLContextMenuSearchAction.appendWorkingSets((IMenuManager)refMenu, viewer, 1, bEnabled, declaringFile);
        MenuManager declMenu = new MenuManager(EGLSearchMessages.EGLSearchActionDeclaration);
        declMenu.add((IAction)new EGLContextMenuSearchAction(viewer, 0, 0, EGLSearchMessages.EGLSearchActionWorkspace, bEnabled, declaringFile, null));
        declMenu.add((IAction)new EGLContextMenuSearchAction(viewer, 3, 0, EGLSearchMessages.EGLSearchActionProject, bEnabled && declaringFile != null, declaringFile, null));
        if (parts != null) {
            declMenu.add((IAction)new EGLContextMenuSearchAction(viewer, 3, 0, EGLSearchMessages.EGLSearchActionPartslist, bEnabled && parts != null, declaringFile, parts));
        }
        declMenu.add((IAction)new EGLContextMenuSearchAction(viewer, 2, 0, EGLSearchMessages.EGLSearchActionWorkingset, bEnabled, declaringFile, null));
        declMenu.add((IContributionItem)new Separator());
        EGLContextMenuSearchAction.appendWorkingSets((IMenuManager)declMenu, viewer, 0, bEnabled, declaringFile);
        menu.add((IContributionItem)refMenu);
        menu.add((IContributionItem)declMenu);
    }
}

