/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.ui.internal.refactoring.changes.EGLFileChange;
import org.eclipse.ltk.core.refactoring.TextChange;

public class TextChangeManager {
    private Map fMap = new HashMap(10);
    private final boolean fKeepExecutedTextEdits;

    public TextChangeManager() {
        this(false);
    }

    public TextChangeManager(boolean keepExecutedTextEdits) {
        this.fKeepExecutedTextEdits = keepExecutedTextEdits;
    }

    public void manage(IEGLFile cu, TextChange change) {
        this.fMap.put(cu, change);
    }

    public TextChange get(IEGLFile cu) {
        Object result = (TextChange)this.fMap.get(cu);
        if (result == null) {
            result = new EGLFileChange(cu.getElementName(), cu);
            result.setKeepPreviewEdits(this.fKeepExecutedTextEdits);
            this.fMap.put(cu, result);
        }
        return result;
    }

    public TextChange remove(IEGLFile unit) {
        return (TextChange)this.fMap.remove(unit);
    }

    public TextChange[] getAllChanges() {
        Set cuSet = this.fMap.keySet();
        IEGLFile[] cus = cuSet.toArray(new IEGLFile[cuSet.size()]);
        Arrays.sort(cus, new Comparator(){

            public int compare(Object o1, Object o2) {
                String name1 = ((IEGLFile)o1).getElementName();
                String name2 = ((IEGLFile)o2).getElementName();
                return name1.compareTo(name2);
            }
        });
        TextChange[] textChanges = new TextChange[cus.length];
        int i = 0;
        while (i < cus.length) {
            textChanges[i] = (TextChange)this.fMap.get(cus[i]);
            ++i;
        }
        return textChanges;
    }

    public IEGLFile[] getAllCompilationUnits() {
        return this.fMap.keySet().toArray(new IEGLFile[this.fMap.keySet().size()]);
    }

    public void clear() {
        this.fMap.clear();
    }

    public boolean containsChangesIn(IEGLFile cu) {
        return this.fMap.containsKey(cu);
    }
}

