/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring.reorg;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.packageexplorer.EGLElementLabelProvider;
import org.eclipse.edt.ide.ui.internal.packageexplorer.EGLElementSorter;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.DestinationContentProvider;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.IReorgDestinationValidator;
import org.eclipse.edt.ide.ui.internal.viewsupport.EGLElementLabels;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

abstract class ReorgUserInputPage
extends UserInputWizardPage {
    private static final int LABEL_FLAGS = 1043;
    private TreeViewer fViewer;

    public ReorgUserInputPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite result = new Composite(parent, 0);
        this.setControl((Control)result);
        result.setLayout((Layout)new GridLayout());
        Object initialSelection = this.getInitiallySelectedElement();
        this.verifyDestination(initialSelection, true);
        this.addLabel(result);
        this.fViewer = this.createViewer(result);
        this.fViewer.setSelection((ISelection)new StructuredSelection(initialSelection), true);
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ReorgUserInputPage.this.viewerSelectionChanged(event);
            }
        });
        Dialog.applyDialogFont((Control)result);
    }

    protected Control addLabel(Composite parent) {
        Label label = new Label(parent, 0);
        int resources = this.getResources().length;
        int eglElements = this.getEGLElements().length;
        String text = resources == 0 && eglElements == 1 ? MessageFormat.format((String)UINlsStrings.ReorgUserInputPage_choose_destination_single, (Object[])new String[]{EGLElementLabels.getElementLabel(this.getEGLElements()[0], 1043)}) : (resources == 1 && eglElements == 0 ? MessageFormat.format((String)UINlsStrings.ReorgUserInputPage_choose_destination_single, (Object[])new String[]{this.getResources()[0].getName()}) : MessageFormat.format((String)UINlsStrings.ReorgUserInputPage_choose_destination_multi, (Object[])new String[]{String.valueOf(resources + eglElements)}));
        label.setText(text);
        label.setLayoutData((Object)new GridData(1, 0x1000008, false, false));
        return label;
    }

    private void viewerSelectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        this.verifyDestination(ss.getFirstElement(), false);
    }

    protected abstract Object getInitiallySelectedElement();

    protected abstract RefactoringStatus verifyDestination(Object var1) throws EGLModelException;

    protected abstract IResource[] getResources();

    protected abstract IEGLElement[] getEGLElements();

    protected abstract IReorgDestinationValidator getDestinationValidator();

    private final void verifyDestination(Object selected, boolean initialVerification) {
        try {
            RefactoringStatus status = this.verifyDestination(selected);
            if (initialVerification) {
                this.setPageComplete(status.isOK());
            } else {
                this.setPageComplete(status);
            }
        }
        catch (EGLModelException e) {
            EDTUIPlugin.log(e);
            this.setPageComplete(false);
        }
    }

    private TreeViewer createViewer(Composite parent) {
        TreeViewer treeViewer = new TreeViewer(parent, 2820);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(40);
        gd.heightHint = this.convertHeightInCharsToPixels(15);
        treeViewer.getTree().setLayoutData((Object)gd);
        treeViewer.setLabelProvider((IBaseLabelProvider)new EGLElementLabelProvider(256));
        treeViewer.setContentProvider((IContentProvider)new DestinationContentProvider(this.getDestinationValidator()));
        treeViewer.setSorter((ViewerSorter)new EGLElementSorter());
        treeViewer.setInput((Object)EGLCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        return treeViewer;
    }

    protected TreeViewer getTreeViewer() {
        return this.fViewer;
    }
}

