/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring.changes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.ui.internal.refactoring.changes.CreateTextFileChange;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.INewNameQuery;
import org.eclipse.ltk.core.refactoring.Change;

public class CreateCopyOfEGLFileChange
extends CreateTextFileChange {
    private IEGLFile fOldCu;
    private INewNameQuery fNameQuery;

    public CreateCopyOfEGLFileChange(IPath path, String source, IEGLFile oldCu, INewNameQuery nameQuery) {
        super(path, source, null, "egl");
        this.fOldCu = oldCu;
        this.fNameQuery = nameQuery;
        this.setEncoding(oldCu);
    }

    @Override
    public Change perform(IProgressMonitor pm) throws CoreException {
        Change result = super.perform(pm);
        return result;
    }

    private void setEncoding(IEGLFile cunit) {
        IResource resource = cunit.getResource();
        if (!(resource instanceof IFile)) {
            return;
        }
        IFile file = (IFile)resource;
        try {
            String encoding = file.getCharset(false);
            if (encoding != null) {
                this.setEncoding(encoding, true);
            } else {
                encoding = file.getCharset(true);
                if (encoding != null) {
                    this.setEncoding(encoding, false);
                }
            }
        }
        catch (CoreException coreException) {}
    }

    @Override
    protected IFile getOldFile(IProgressMonitor pm) {
        pm.beginTask("", 10);
        String oldSource = super.getSource();
        IPath oldPath = super.getPath();
        String newTypeName = this.fNameQuery.getNewName();
        try {
            String newSource = CreateCopyOfEGLFileChange.getCopiedFileSource((IProgressMonitor)new SubProgressMonitor(pm, 9), this.fOldCu, newTypeName);
            this.setSource(newSource);
            this.setPath(this.constructNewPath(newTypeName));
            return super.getOldFile((IProgressMonitor)new SubProgressMonitor(pm, 1));
        }
        catch (CoreException coreException) {
            this.setSource(oldSource);
            this.setPath(oldPath);
            return super.getOldFile(pm);
        }
    }

    private IPath constructNewPath(String newTypeName) {
        String newCUName = this.getRenamedCUName(this.fOldCu, newTypeName);
        return this.fOldCu.getResource().getParent().getFullPath().append(newCUName);
    }

    private String getRenamedCUName(IEGLFile cu, String newMainName) {
        String oldName = cu.getElementName();
        int i = oldName.lastIndexOf(46);
        if (i != -1) {
            return String.valueOf(newMainName) + oldName.substring(i);
        }
        return newMainName;
    }

    private static String getCopiedFileSource(IProgressMonitor pm, IEGLFile cu, String newTypeName) throws CoreException {
        String result = null;
        IEGLFile wc = (IEGLFile)cu.getWorkingCopy();
        try {
            result = wc.getBuffer().getContents();
        }
        finally {
            wc.destroy();
        }
        return result;
    }
}

