/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.edt.ide.ui.internal.actions.WorkbenchRunnableAdapter;
import org.eclipse.edt.ide.ui.internal.refactoring.RefactoringSaveHelper;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.IThreadListener;
import org.eclipse.jface.text.Assert;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringUI;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class RefactoringExecutionHelper {
    private final Refactoring fRefactoring;
    private final Shell fParent;
    private final IRunnableContext fExecContext;
    private final int fStopSeverity;
    private final boolean fNeedsSavedEditors;

    public RefactoringExecutionHelper(Refactoring refactoring, int stopSevertity, boolean needsSavedEditors, Shell parent, IRunnableContext context) {
        Assert.isNotNull((Object)refactoring);
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)context);
        this.fRefactoring = refactoring;
        this.fStopSeverity = stopSevertity;
        this.fParent = parent;
        this.fExecContext = context;
        this.fNeedsSavedEditors = needsSavedEditors;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void perform(boolean cancelable) throws InterruptedException, InvocationTargetException {
        Assert.isTrue((Display.getCurrent() != null ? 1 : 0) != 0);
        final IJobManager manager = Platform.getJobManager();
        final IWorkspaceRoot rule = ResourcesPlugin.getWorkspace().getRoot();
        try {
            try {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        manager.beginRule((ISchedulingRule)rule, null);
                    }
                };
                BusyIndicator.showWhile((Display)this.fParent.getDisplay(), (Runnable)r);
            }
            catch (OperationCanceledException e) {
                throw new InterruptedException(e.getMessage());
            }
            RefactoringSaveHelper saveHelper = new RefactoringSaveHelper();
            if (this.fNeedsSavedEditors && !saveHelper.saveEditors(this.fParent)) {
                throw new InterruptedException();
            }
            Operation op = new Operation();
            this.fRefactoring.setValidationContext((Object)this.fParent);
            try {
                class OperationRunner
                extends WorkbenchRunnableAdapter
                implements IThreadListener {
                    private final /* synthetic */ IJobManager val$manager;

                    public OperationRunner(IWorkspaceRunnable runnable, ISchedulingRule schedulingRule, IJobManager iJobManager) {
                        this.val$manager = iJobManager;
                        super(runnable, schedulingRule);
                    }

                    public void threadChange(Thread thread) {
                        this.val$manager.transferRule(this.getSchedulingRule(), thread);
                    }
                }
                this.fExecContext.run(false, cancelable, (IRunnableWithProgress)new OperationRunner(op, (ISchedulingRule)rule, manager));
                RefactoringStatus validationStatus = op.fPerformChangeOperation.getValidationStatus();
                if (validationStatus == null) {
                }
                if (validationStatus.hasFatalError()) {
                    return;
                }
            }
            catch (InvocationTargetException e) {
                PerformChangeOperation cfr_ignored_0 = op.fPerformChangeOperation;
                throw e;
            }
            catch (OperationCanceledException e) {
                throw new InterruptedException(e.getMessage());
            }
            finally {
                saveHelper.triggerBuild();
            }
        }
        finally {
            manager.endRule((ISchedulingRule)rule);
            this.fRefactoring.setValidationContext(null);
        }
    }

    private class Operation
    implements IWorkspaceRunnable {
        public Change fChange;
        public PerformChangeOperation fPerformChangeOperation;

        private Operation() {
        }

        public void run(IProgressMonitor pm) throws CoreException {
            try {
                Dialog dialog;
                pm.beginTask("", 11);
                pm.subTask("");
                RefactoringStatus status = RefactoringExecutionHelper.this.fRefactoring.checkAllConditions((IProgressMonitor)new SubProgressMonitor(pm, 4, 4));
                if (status.getSeverity() >= RefactoringExecutionHelper.this.fStopSeverity && (dialog = RefactoringUI.createRefactoringStatusDialog((RefactoringStatus)status, (Shell)RefactoringExecutionHelper.this.fParent, (String)RefactoringExecutionHelper.this.fRefactoring.getName(), (boolean)false)).open() == 1) {
                    throw new OperationCanceledException();
                }
                this.fChange = RefactoringExecutionHelper.this.fRefactoring.createChange((IProgressMonitor)new SubProgressMonitor(pm, 2, 4));
                this.fChange.initializeValidationData((IProgressMonitor)new SubProgressMonitor(pm, 1, 4));
                this.fPerformChangeOperation = RefactoringUI.createUIAwareChangeOperation((Change)this.fChange);
                this.fPerformChangeOperation.setUndoManager(RefactoringCore.getUndoManager(), RefactoringExecutionHelper.this.fRefactoring.getName());
                this.fPerformChangeOperation.run((IProgressMonitor)new SubProgressMonitor(pm, 4, 4));
            }
            finally {
                pm.done();
            }
        }
    }
}

