/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.record.wizards;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusUtil;
import org.eclipse.edt.ide.ui.internal.record.NewRecordWizardMessages;
import org.eclipse.edt.ide.ui.internal.record.wizards.ReadProgressMonitorDialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractRecordFromStringInputPage
extends WizardPage
implements SelectionListener,
ModifyListener {
    protected Button createFromUrlButton;
    protected Composite urlConfigComposite;
    protected Combo urlText;
    protected String[] recentUrls;
    protected Button createFromFileButton;
    protected Composite fileConfigComposite;
    protected Combo fileText;
    protected Button browseButton;
    protected String[] recentFilePaths;
    protected Button createFromStringButton;
    protected Composite stringConfigComposite;
    protected Text stringText;
    protected ISelection selection;
    protected boolean inputNeedsProcessing = true;

    public AbstractRecordFromStringInputPage(ISelection selection) {
        super(NewRecordWizardMessages.AbstractRecordFromStringInputPage_pageName);
        this.selection = selection;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        this.createFromUrlButton = this.createFromUrlButton(container);
        this.urlConfigComposite = this.createUrlComposite(container);
        GridData data = new GridData(768);
        data.horizontalIndent = 18;
        this.urlConfigComposite.setLayoutData((Object)data);
        this.createFromFileButton = this.createFromFileButton(container);
        this.fileConfigComposite = this.createFileComposite(container);
        data = new GridData(768);
        data.horizontalIndent = 18;
        this.fileConfigComposite.setLayoutData((Object)data);
        this.createFromStringButton = this.createFromStringButton(container);
        this.stringConfigComposite = this.createStringComposite(container);
        data = new GridData(4, 4, true, true);
        data.horizontalIndent = 18;
        this.stringConfigComposite.setLayoutData((Object)data);
        this.createFromStringButton.setSelection(true);
        this.enableComposite(this.urlConfigComposite, this.createFromUrlButton.getSelection());
        this.enableComposite(this.fileConfigComposite, this.createFromFileButton.getSelection());
        this.enableComposite(this.stringConfigComposite, this.createFromStringButton.getSelection());
        this.setControl((Control)container);
        this.ok(false);
    }

    protected Button createFromUrlButton(Composite container) {
        return this.createOptionButton(container, NewRecordWizardMessages.AbstractRecordFromStringInputPage_createFromURL);
    }

    protected Button createFromFileButton(Composite container) {
        return this.createOptionButton(container, NewRecordWizardMessages.AbstractRecordFromStringInputPage_createFromFile);
    }

    protected Button createFromStringButton(Composite container) {
        return this.createOptionButton(container, NewRecordWizardMessages.AbstractRecordFromStringInputPage_createFromString);
    }

    protected Button createOptionButton(Composite container, String text) {
        Button button = new Button(container, 16);
        button.setText(text);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        button.addSelectionListener((SelectionListener)this);
        return button;
    }

    protected Composite createFileComposite(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText(NewRecordWizardMessages.AbstractRecordFromStringInputPage_fileLabel);
        Composite c = new Composite(container, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        c.setLayout((Layout)layout);
        c.setLayoutData((Object)new GridData(768));
        this.fileText = new Combo(c, 2052);
        this.fileText.setLayoutData((Object)new GridData(768));
        if (this.recentFilePaths != null) {
            this.fileText.setItems(this.recentFilePaths);
        }
        this.fileText.addModifyListener((ModifyListener)this);
        this.browseButton = new Button(c, 8);
        this.browseButton.setText(NewRecordWizardMessages.AbstractRecordFromStringInputPage_browseLabel);
        this.browseButton.addSelectionListener((SelectionListener)this);
        return container;
    }

    protected Composite createUrlComposite(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText(NewRecordWizardMessages.AbstractRecordFromStringInputPage_urlLabel);
        Composite c = new Composite(container, 0);
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        c.setLayout((Layout)layout);
        c.setLayoutData((Object)new GridData(768));
        this.urlText = new Combo(c, 2052);
        this.urlText.setLayoutData((Object)new GridData(768));
        if (this.recentUrls != null) {
            this.urlText.setItems(this.recentUrls);
        }
        this.urlText.addModifyListener((ModifyListener)this);
        return container;
    }

    protected Composite createStringComposite(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText(NewRecordWizardMessages.AbstractRecordFromStringInputPage_stringEntryLabel);
        this.stringText = new Text(container, 2562);
        this.stringText.setFont(JFaceResources.getTextFont());
        GridData data = new GridData(4, 4, true, true);
        this.stringText.setLayoutData((Object)data);
        this.stringText.addModifyListener((ModifyListener)this);
        return container;
    }

    public void modifyText(ModifyEvent event) {
        this.inputNeedsProcessing = true;
        this.validatePage();
    }

    public Object getInput() {
        String input = null;
        if (this.createFromStringButton.getSelection()) {
            input = this.stringText.getText();
        } else if (this.createFromUrlButton.getSelection() || this.createFromFileButton.getSelection() && this.fileText.getText().trim().length() != 0) {
            try {
                ReadProgressMonitorDialog dialog;
                if (this.createFromUrlButton.getSelection()) {
                    URL url = new URL(this.urlText.getText());
                    dialog = new ReadProgressMonitorDialog(this.getShell(), url);
                } else {
                    dialog = new ReadProgressMonitorDialog(this.getShell(), new File(this.fileText.getText()));
                }
                dialog.run();
                if (dialog.isStatusSuccess()) {
                    input = dialog.getInput();
                } else if (!dialog.isStatusCanceled()) {
                    this.error(dialog.getError());
                }
            }
            catch (Exception ex) {
                this.error(ex.getMessage());
            }
        }
        return input;
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.getSource() == this.createFromFileButton) {
            this.enableComposite(this.fileConfigComposite, this.createFromFileButton.getSelection());
        } else if (event.getSource() == this.createFromUrlButton) {
            this.enableComposite(this.urlConfigComposite, this.createFromUrlButton.getSelection());
        } else if (event.getSource() == this.createFromStringButton) {
            this.enableComposite(this.stringConfigComposite, this.createFromStringButton.getSelection());
        } else if (event.getSource() == this.browseButton) {
            FileDialog dialog = new FileDialog(this.getShell());
            dialog.setFilterExtensions(this.getValidInputFileExtensions());
            if (dialog.open() != null) {
                this.fileText.setText(String.valueOf(dialog.getFilterPath()) + File.separator + dialog.getFileName());
            }
        }
        this.inputNeedsProcessing = true;
        this.validatePage();
    }

    protected void validatePage() {
        String errorMessage = null;
        if (this.createFromUrlButton.getSelection()) {
            if (this.urlText.getText().trim().length() > 0) {
                try {
                    new URL(this.urlText.getText());
                }
                catch (MalformedURLException ex) {
                    errorMessage = ex.getMessage();
                }
            } else {
                errorMessage = NewRecordWizardMessages.AbstractRecordFromStringInputPage_enterURLMessage;
            }
        } else if (this.createFromFileButton.getSelection()) {
            if (this.fileText.getText().trim().length() == 0) {
                errorMessage = NewRecordWizardMessages.AbstractRecordFromStringInputPage_enterFilenameMessage;
            }
        } else if (this.createFromStringButton.getSelection() && this.stringText.getText().trim().length() == 0) {
            errorMessage = NewRecordWizardMessages.AbstractRecordFromStringInputPage_enterStringMessage;
        }
        if (errorMessage == null) {
            this.ok(true);
        } else {
            this.error(errorMessage);
        }
    }

    protected void ok(boolean bool) {
        StatusInfo status = new StatusInfo();
        status.setOK();
        this.setPageComplete(bool);
        StatusUtil.applyToStatusLine((DialogPage)this, (IStatus)status);
    }

    protected void error(String str) {
        StatusInfo status = new StatusInfo();
        status.setError(str);
        this.setPageComplete(false);
        StatusUtil.applyToStatusLine((DialogPage)this, (IStatus)status);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected abstract String[] getValidInputFileExtensions();

    private void enableComposite(Composite c, boolean enabled) {
        Control[] controls = c.getChildren();
        int i = 0;
        while (i < controls.length) {
            if (controls[i] instanceof Composite) {
                this.enableComposite((Composite)controls[i], enabled);
            }
            controls[i].setEnabled(enabled);
            ++i;
        }
    }

    public boolean isInputNeedsProcessing() {
        return this.inputNeedsProcessing;
    }

    public void setInputNeedsProcessing(boolean b) {
        this.inputNeedsProcessing = b;
    }

    public void setRecentUrls(String[] urls) {
        this.recentUrls = urls;
    }

    public void setRecentFilePaths(String[] filePaths) {
        this.recentFilePaths = filePaths;
    }

    public boolean isUrlSource() {
        return this.createFromUrlButton.getSelection();
    }

    public boolean isFileSource() {
        return this.createFromFileButton.getSelection();
    }

    public boolean isStringSource() {
        return this.createFromStringButton.getSelection();
    }

    public String getUrl() {
        return this.urlText.getText();
    }

    public String getFilePath() {
        return this.fileText.getText();
    }
}

