/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.record.conversion;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.edt.compiler.internal.core.builder.DefaultProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultCompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.ide.ui.internal.record.NewRecordWizardMessages;
import org.eclipse.edt.ide.ui.internal.record.conversion.IMessageHandler;
import org.eclipse.edt.ide.ui.templates.parts.Field;
import org.eclipse.edt.ide.ui.templates.parts.Part;
import org.eclipse.edt.ide.ui.templates.parts.Record;

public abstract class PartsUtil {
    static Map<String, String> _reservedConversionNames = new HashMap<String, String>();
    static final String subChar = "";
    private HashMap<String, String> _partNames = new HashMap();
    private int _aliasNumber = 0;
    protected IMessageHandler _msgHandler = null;

    static {
        _reservedConversionNames.put("egl_value", "egl_value");
    }

    protected PartsUtil(IMessageHandler msgHandler) {
        this._msgHandler = msgHandler;
    }

    private String getName(String str, DefaultProblemRequestor problemRequestor) {
        EGLNameValidator.validate((String)str, (int)1, (IProblemRequestor)problemRequestor, (ICompilerOptions)DefaultCompilerOptions.getInstance());
        return str;
    }

    public String getTypeName(String str) {
        NameValidatorProblemRequestor problemRequestor = new NameValidatorProblemRequestor();
        String name = this.fixName(str, null);
        boolean isValidName = false;
        while (!isValidName) {
            try {
                name = this.getName(name, problemRequestor);
                isValidName = true;
            }
            catch (RuntimeException runtimeException) {
                if (problemRequestor.getProblemKind() == 3019) {
                    String newName = String.valueOf(name) + ++this._aliasNumber;
                    this._msgHandler.addMessage(NewRecordWizardMessages.bind((String)NewRecordWizardMessages.PartsUtil_reservedWordRenameMessage, (Object[])new String[]{name, this.getFinalType(newName)}));
                    name = newName;
                    problemRequestor.setProblemKind(0);
                }
                throw new RuntimeException(DefaultProblemRequestor.getMessageFromBundle((int)problemRequestor.getProblemKind(), (String[])problemRequestor.getInserts(), (ResourceBundle)problemRequestor.getBundle()));
            }
            if (problemRequestor.getProblemKind() == 0) continue;
            throw new RuntimeException(DefaultProblemRequestor.getMessageFromBundle((int)problemRequestor.getProblemKind(), (String[])problemRequestor.getInserts(), (ResourceBundle)problemRequestor.getBundle()));
        }
        return this.getFinalType(name);
    }

    protected void mergeRecords(Record oldrec, Record newrec) {
        Field[] oldFields = oldrec.getFields();
        int i = 0;
        while (i < oldFields.length) {
            Field newField = newrec.getField(oldFields[i].getName());
            if (newField == null) {
                if (!oldFields[i].getType().isNullable() && !oldFields[i].getType().isReferenceType()) {
                    this._msgHandler.addMessage(NewRecordWizardMessages.bind((String)NewRecordWizardMessages.PartsUtil_definedAsNullableMessage, (Object[])new String[]{newrec.getName(), oldFields[i].getName()}));
                }
                oldFields[i].getType().setNullable(true);
                newrec.addField(oldFields[i]);
            } else {
                newField.getType().setNullable(oldFields[i].getType().isNullable());
            }
            ++i;
        }
        Field[] newFields = newrec.getFields();
        int i2 = 0;
        while (i2 < newFields.length) {
            if (oldrec.getField(newFields[i2].getName()) == null) {
                if (!newFields[i2].getType().isNullable() && !newFields[i2].getType().isReferenceType()) {
                    this._msgHandler.addMessage(NewRecordWizardMessages.bind((String)NewRecordWizardMessages.PartsUtil_definedAsNullableMessage, (Object[])new String[]{newrec.getName(), newFields[i2].getName()}));
                }
                newFields[i2].getType().setNullable(true);
            }
            ++i2;
        }
    }

    public abstract Part[] process(Object var1, Record var2);

    private boolean isNameCollision(String name, boolean isOriginalName, HashMap<String, String> fieldNames) {
        boolean isCollision = false;
        isCollision = !isOriginalName && fieldNames.containsKey(name.toLowerCase()) || this._partNames.containsKey(this.getFinalName(name).toLowerCase()) || _reservedConversionNames.containsKey(this.getFinalName(name).toLowerCase());
        return isCollision;
    }

    protected String getFieldName(String str, String recordName, HashMap<String, String> fieldNames) {
        NameValidatorProblemRequestor problemRequestor = new NameValidatorProblemRequestor();
        String name = this.fixName(str, recordName);
        boolean isValidName = false;
        while (!isValidName) {
            String newName;
            try {
                if (this.isNameCollision(name, name.equals(str), fieldNames)) {
                    newName = String.valueOf(name) + ++this._aliasNumber;
                    this._msgHandler.addMessage(NewRecordWizardMessages.bind((String)NewRecordWizardMessages.PartsUtil_renameFieldInUseMessage, (Object[])new String[]{name, this.getFinalName(newName), recordName}));
                    name = newName;
                }
                name = this.getName(name, problemRequestor);
                isValidName = true;
            }
            catch (RuntimeException runtimeException) {
                if (problemRequestor.getProblemKind() == 3019) {
                    newName = String.valueOf(name) + ++this._aliasNumber;
                    this._msgHandler.addMessage(NewRecordWizardMessages.bind((String)NewRecordWizardMessages.PartsUtil_reservedWordRename2Message, (Object[])new String[]{name, this.getFinalName(newName), recordName}));
                    name = newName;
                    problemRequestor.setProblemKind(0);
                }
                throw new RuntimeException(DefaultProblemRequestor.getMessageFromBundle((int)problemRequestor.getProblemKind(), (String[])problemRequestor.getInserts(), (ResourceBundle)problemRequestor.getBundle()));
            }
            if (problemRequestor.getProblemKind() == 0) continue;
            throw new RuntimeException(DefaultProblemRequestor.getMessageFromBundle((int)problemRequestor.getProblemKind(), (String[])problemRequestor.getInserts(), (ResourceBundle)problemRequestor.getBundle()));
        }
        name = this.getFinalName(name);
        this._partNames.put(name.toLowerCase(), name);
        return name;
    }

    private String getFinalName(String name) {
        if (name.equals(name.toUpperCase())) {
            return name.toLowerCase();
        }
        return String.valueOf(name.substring(0, 1).toLowerCase()) + name.substring(1);
    }

    private String getFinalType(String name) {
        if (!name.equals(name.toUpperCase())) {
            name = String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
        }
        return name;
    }

    private String fixName(String name, String recordName) {
        int i;
        boolean isVAGCompatibility = false;
        StringBuffer eName = new StringBuffer(name);
        if (!isVAGCompatibility) {
            if (!Character.isJavaIdentifierStart(eName.charAt(0))) {
                eName.replace(1, 2, eName.substring(1, 2).toUpperCase());
                eName.replace(0, 1, subChar);
            }
            i = 1;
            while (i < eName.length()) {
                if (!Character.isJavaIdentifierPart(eName.charAt(i))) {
                    eName.replace(i + 1, i + 2, eName.substring(i + 1, i + 2).toUpperCase());
                    eName.replace(i, i + 1, subChar);
                    --i;
                }
                ++i;
            }
        } else {
            if (!Character.isJavaIdentifierStart(eName.charAt(0))) {
                eName.replace(1, 2, eName.substring(1, 2).toUpperCase());
                eName.replace(0, 1, subChar);
            }
            i = 1;
            while (i < eName.length()) {
                if (!Character.isJavaIdentifierPart(eName.charAt(i)) && eName.charAt(i) != '-' && eName.charAt(i) != '@' && eName.charAt(i) != '#' && eName.charAt(i) != ' ') {
                    eName.replace(i + 1, i + 2, eName.substring(i + 1, i + 2).toUpperCase());
                    eName.replace(i, i + 1, subChar);
                    --i;
                }
                ++i;
            }
        }
        String newName = eName.toString();
        if (!name.equalsIgnoreCase(newName)) {
            this._msgHandler.addMessage(NewRecordWizardMessages.bind((String)NewRecordWizardMessages.PartsUtil_invalidCharactersRenameMessage, (Object[])new String[]{name, this.getFinalName(newName), recordName == null ? subChar : NewRecordWizardMessages.bind((String)NewRecordWizardMessages.PartsUtil_invalidCharactersRename2Message, (Object[])new String[]{recordName})}));
        }
        return newName;
    }

    private class NameValidatorProblemRequestor
    extends DefaultProblemRequestor {
        int _problemKind = 0;
        int _severity = 0;
        String[] _inserts = new String[0];
        ResourceBundle _bundle;

        public void acceptProblem(int startOffset, int endOffset, int severity, int problemKind, String[] inserts, ResourceBundle bundle) {
            this._bundle = bundle;
            if (this._problemKind == 0) {
                this._inserts = NameValidatorProblemRequestor.shiftInsertsIfNeccesary((int)problemKind, (String[])inserts);
                this._problemKind = problemKind;
                this._severity = severity;
            }
            if (this._severity > 1) {
                throw new RuntimeException(NameValidatorProblemRequestor.getMessageFromBundle((int)problemKind, (String[])inserts, (ResourceBundle)bundle));
            }
        }

        public int getProblemKind() {
            return this._problemKind;
        }

        public void setProblemKind(int problemKind) {
            this._problemKind = problemKind;
        }

        public String[] getInserts() {
            return this._inserts;
        }

        public ResourceBundle getBundle() {
            return this._bundle;
        }
    }
}

