/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.record;

import java.util.List;
import org.eclipse.edt.ide.ui.editor.EGLCodeFormatterUtil;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.editor.DocumentProvider;
import org.eclipse.edt.ide.ui.internal.editor.EGLSourceViewerConfiguration;
import org.eclipse.edt.ide.ui.internal.editor.TextTools;
import org.eclipse.edt.ide.ui.internal.record.NewRecordWizardMessages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class NewRecordSummaryPage
extends WizardPage {
    private SourceViewer fPreviewViewer;
    private IDocument document;
    private Label warningLabel;
    private Table messageList;
    private Composite messageComposite;

    public NewRecordSummaryPage(ISelection selection) {
        super(NewRecordWizardMessages.NewRecordSummaryPage_pageName);
        this.setTitle(NewRecordWizardMessages.NewRecordSummaryPage_pageTitle);
        this.setDescription(NewRecordWizardMessages.NewRecordSummaryPage_pageDescription);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, IUIHelpConstants.EGL_NEW_RECORD_SUMMARY_PAGE);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 1;
        Label label = new Label(container, 256);
        label.setText(NewRecordWizardMessages.NewRecordSummaryPage_previewLabel);
        TextTools tools = new TextTools((IPreferenceStore)new PreferenceStore());
        this.fPreviewViewer = new SourceViewer(container, null, 2816);
        this.fPreviewViewer.configure((SourceViewerConfiguration)new EGLSourceViewerConfiguration(tools, null));
        Font font = JFaceResources.getFont((String)"org.eclipse.edt.ide.ui.editors.textfont");
        this.fPreviewViewer.getTextWidget().setFont(font);
        this.fPreviewViewer.setEditable(false);
        this.fPreviewViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.document = new Document("");
        IDocumentPartitioner partitioner = ((DocumentProvider)EGLUI.getDocumentProvider()).createDocumentPartitioner();
        this.document.setDocumentPartitioner(partitioner);
        partitioner.connect(this.document);
        this.fPreviewViewer.setDocument(this.document);
        this.messageComposite = new HideableComposite(container, 0);
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.messageComposite.setLayout((Layout)layout);
        this.messageComposite.setLayoutData((Object)new GridData(768));
        this.warningLabel = new Label(this.messageComposite, 256);
        this.warningLabel.setText(NewRecordWizardMessages.NewRecordSummaryPage_warningLabel);
        this.warningLabel.setLayoutData((Object)new GridData(768));
        this.messageList = new Table(this.messageComposite, 68352);
        this.messageList.setLinesVisible(false);
        GridData data = new GridData(768);
        data.heightHint = 80;
        this.messageList.setLayoutData((Object)data);
        this.setControl((Control)container);
    }

    public void setContent(String str) {
        this.document.set(str != null ? str : "");
        try {
            TextEdit edit = EGLCodeFormatterUtil.format(this.document, null);
            edit.apply(this.document);
        }
        catch (Exception exception) {}
    }

    public void setMessages(List<String> messages) {
        this.messageList.removeAll();
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        if (messages != null && messages.size() > 0) {
            for (String message : messages) {
                TableItem item = new TableItem(this.messageList, 0);
                item.setImage(sharedImages.getImage("IMG_OBJS_WARN_TSK"));
                item.setText(message);
            }
        }
        this.messageComposite.setVisible(this.messageList.getItemCount() > 0);
        if (this.messageList.getItemCount() == 0) {
            this.messageComposite.setVisible(false);
        } else {
            this.warningLabel.setText(NewRecordWizardMessages.bind((String)NewRecordWizardMessages.NewRecordSummaryPage_warningLabel2, (Object[])new String[]{Integer.toString(this.messageList.getItemCount())}));
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.messageComposite != null) {
            this.messageComposite.setVisible(this.messageList.getItemCount() > 0);
        }
    }

    private static class HideableComposite
    extends Composite {
        public HideableComposite(Composite parent, int style) {
            super(parent, style);
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            if (this.isVisible()) {
                return super.computeSize(wHint, hHint, changed);
            }
            return new Point(0, 0);
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            this.pack(true);
            this.getParent().layout(true);
        }
    }
}

