/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.quickfix.proposals.sql;

import java.util.List;
import org.eclipse.edt.ide.ui.internal.editor.sql.SQLIOStatementUtility;
import org.eclipse.edt.ide.ui.internal.quickfix.proposals.sql.EGLSQLClauseFactory;
import org.eclipse.edt.ide.ui.internal.quickfix.proposals.sql.EGLSQLDeclareStatementFactory;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Member;

public class EGLSQLGetByKeyForUpdateStatementFactory
extends EGLSQLDeclareStatementFactory {
    String forUpdateOfClause = null;
    String[] columnsExcludingReadOnlyAndKeys = null;

    public EGLSQLGetByKeyForUpdateStatementFactory(Member recordBinding, String ioObjectName, List userDefinedIntoItemNames, String[][] keyItemAndColumnNames, boolean isDynamicArrayRecord) {
        super(recordBinding, ioObjectName, userDefinedIntoItemNames, keyItemAndColumnNames, isDynamicArrayRecord);
    }

    public EGLSQLGetByKeyForUpdateStatementFactory(Member recordBinding, String ioObjectName) {
        super(recordBinding, ioObjectName, null, null, false);
    }

    @Override
    public String buildDefaultSQLStatement() {
        super.buildDefaultSQLStatement();
        if (this.sqlStatement != null) {
            this.columnsExcludingReadOnlyAndKeys = this.getColumnsExcludingReadOnlyAndKeys();
            if (this.columnsExcludingReadOnlyAndKeys != null) {
                this.forUpdateOfClause = EGLSQLClauseFactory.createDefaultForUpdateOfClause(this.columnsExcludingReadOnlyAndKeys);
                if (this.forUpdateOfClause != null) {
                    this.sqlStatement = String.valueOf(this.sqlStatement) + this.forUpdateOfClause;
                }
            }
        }
        return this.sqlStatement;
    }

    private String[] getColumnsExcludingReadOnlyAndKeys() {
        String[] columns = new String[this.numSQLDataItems];
        int numNonReadOnlyAndKeys = 0;
        if (this.structureItemBindings != null) {
            for (Field itemBinding : this.structureItemBindings) {
                String columnName = this.getColumnName(itemBinding);
                boolean isReadOnly = this.getIsReadOnly(itemBinding);
                if (isReadOnly || this.isKey(itemBinding)) continue;
                columns[numNonReadOnlyAndKeys] = columnName;
                ++numNonReadOnlyAndKeys;
            }
        }
        if (numNonReadOnlyAndKeys != 0) {
            String[] readWriteColumns = new String[numNonReadOnlyAndKeys];
            int i = 0;
            while (i < numNonReadOnlyAndKeys) {
                readWriteColumns[i] = columns[i];
                ++i;
            }
            return readWriteColumns;
        }
        return null;
    }

    public String getForUpdateOfClause() {
        return this.forUpdateOfClause;
    }

    @Override
    public String getIOType() {
        return "get forUpdate".toUpperCase();
    }

    @Override
    protected boolean isIoObjectValid() {
        boolean isValid = super.isIoObjectValid();
        if (!this.validateSQLRecordNotJoinAndContainsOneNonReadOnlyOrNonKeyColumn()) {
            isValid = false;
        }
        return isValid;
    }

    private boolean isKey(Field itemBinding) {
        if (this.useRecordKeys) {
            return this.isRecordKeyItem(itemBinding);
        }
        return this.isUsingKeyColumn(itemBinding);
    }

    private boolean isUsingKeyColumn(Field itemBinding) {
        return SQLIOStatementUtility.isUsingKeyColumn(itemBinding, this.keyItemAndColumnNames, this.getSQLRecordTypeBinding());
    }

    @Override
    protected boolean containsOnlyKeyOrReadOnlyColumns() {
        if (!this.useRecordKeys) {
            return SQLIOStatementUtility.containsOnlyKeyOrReadOnlyColumns(this.getSQLRecordTypeBinding(), this.keyItemAndColumnNames);
        }
        return false;
    }
}

