/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.project.wizard.pages;

import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultCompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.project.wizard.fragments.SourceProjectContentFragment;
import org.eclipse.edt.ide.ui.internal.project.wizards.NewEGLProjectWizard;
import org.eclipse.edt.ide.ui.internal.project.wizards.ProjectWizardUtils;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.project.templates.IProjectTemplate;
import org.eclipse.edt.ide.ui.project.templates.ProjectTemplateManager;
import org.eclipse.edt.ide.ui.project.templates.ProjectTemplateWizardNode;
import org.eclipse.edt.ide.ui.wizards.EGLWizardUtilities;
import org.eclipse.edt.ide.ui.wizards.ProjectConfiguration;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer2;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledFormText;

public class ProjectWizardMainPage
extends WizardSelectionPage
implements ISelectionChangedListener,
IDoubleClickListener {
    public static IStatus OK_STATUS = new Status(0, "org.eclipse.edt.ide.ui", 0, "OK", null);
    private Label projectNameLabel;
    private Text projectName;
    private Composite contentSection;
    private SourceProjectContentFragment contentFragment;
    private ProjectConfiguration model;
    protected TableViewer templateViewer;
    protected ScrolledFormText descriptionText;

    public ProjectWizardMainPage(String pageName, ProjectConfiguration model) {
        super(pageName);
        this.model = model;
        this.setTitle(NewWizardMessages.EGLNewProjectWizard_0);
        this.setDescription(NewWizardMessages.EGLProjectWizardTypePage_1);
        this.setImageDescriptor(PluginImages.DESC_WIZBAN_NEWEGLPROJECT);
    }

    public void createControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing *= 2;
        c.setLayout((Layout)layout);
        this.createProjectNameEntry(c);
        this.createLocationArea(c);
        this.createTemplateArea(c);
        this.setControl((Control)c);
        this.projectName.setFocus();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, IUIHelpConstants.NEW_PROJECT_WIZARD_TYPE_PAGE);
        Dialog.applyDialogFont((Control)parent);
        if (this.getContainer().getCurrentPage() != null) {
            this.getContainer().updateButtons();
        }
    }

    private void createProjectNameEntry(Composite parent) {
        this.projectNameLabel = new Label(parent, 0);
        this.projectNameLabel.setText(NewWizardMessages.EGLProjectWizardTypePage_2);
        this.projectName = new Text(parent, 2048);
        this.projectName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String name = ((Text)e.widget).getText();
                ProjectWizardMainPage.this.model.setProjectName(name);
                ProjectWizardMainPage.this.getContainer().updateButtons();
            }
        });
        this.projectName.setLayoutData((Object)new GridData(768));
        this.hookListenerProjectName(this.projectName);
    }

    private void createLocationArea(Composite parent) {
        this.contentFragment = new SourceProjectContentFragment(parent, this);
        this.contentSection = this.contentFragment.renderSection();
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        this.contentSection.setLayoutData((Object)data);
    }

    protected void createTemplateArea(Composite parent) {
        int borderStyle;
        Composite container = new Composite(parent, 0);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        data.heightHint = 300;
        container.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginBottom = 1;
        layout.marginRight = 1;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText(NewWizardMessages.ProjectWizardMainPage_1);
        GridData labelData = new GridData(768);
        labelData.horizontalSpan = 2;
        label.setLayoutData((Object)labelData);
        this.templateViewer = new TableViewer(container, 2048);
        this.templateViewer.setComparator((ViewerComparator)new ViewerSorter());
        Table control = this.templateViewer.getTable();
        GridData gddata = new GridData(1808);
        gddata.widthHint = 250;
        control.setLayoutData((Object)gddata);
        IProjectTemplate[] templates = this.getTemplates();
        this.templateViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.templateViewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.templateViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.templateViewer.setInput((Object)templates);
        this.templateViewer.addDoubleClickListener((IDoubleClickListener)this);
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        this.descriptionText = new ScrolledFormText(container, 768, false);
        int n = borderStyle = toolkit.getBorderStyle() == 2048 ? 0 : 2048;
        if (borderStyle == 0) {
            this.descriptionText.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
            toolkit.paintBordersFor(container);
        }
        FormText ftext = toolkit.createFormText((Composite)this.descriptionText, false);
        this.descriptionText.setFormText(ftext);
        this.descriptionText.setExpandHorizontal(false);
        this.descriptionText.setExpandVertical(false);
        this.descriptionText.setBackground(toolkit.getColors().getBackground());
        this.descriptionText.setForeground(toolkit.getColors().getForeground());
        ftext.marginWidth = 2;
        ftext.marginHeight = 2;
        this.descriptionText.setLayoutData((Object)new GridData(1808));
        if (templates != null) {
            IPreferenceStore store = EDTUIPlugin.getDefault().getPreferenceStore();
            String selectedId = store.getString("newProjectWizard_SelectedTemplate");
            int selectedIndex = -1;
            int defaultIndex = -1;
            int i = 0;
            while (i < templates.length) {
                if (templates[i].getId().equals(selectedId)) {
                    selectedIndex = i;
                }
                if (templates[i].isDefault()) {
                    defaultIndex = i;
                }
                ++i;
            }
            if (selectedIndex < 0) {
                selectedIndex = defaultIndex;
            }
            if (selectedIndex < 0) {
                selectedIndex = 0;
            }
            this.templateViewer.setSelection((ISelection)new StructuredSelection(new Object[]{templates[selectedIndex]}), true);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (o instanceof IProjectTemplate) {
            this.handleSelectedTemplate();
            this.setTemplateDescription(((IProjectTemplate)o).getDescription());
        }
        this.validatePage();
    }

    protected void handleSelectedTemplate() {
        Object o = ((IStructuredSelection)this.templateViewer.getSelection()).getFirstElement();
        if (o instanceof IProjectTemplate) {
            IProjectTemplate template = (IProjectTemplate)o;
            this.model.setSelectedProjectTemplate(template);
            ProjectTemplateWizardNode wizNode = (ProjectTemplateWizardNode)template.getWizardNode();
            if (wizNode != null) {
                wizNode.setParentWizard(this.getWizard());
                this.setSelectedNode(wizNode);
            } else {
                this.setSelectedNode(null);
            }
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.validatePage();
        }
    }

    private void hookListenerProjectName(Text text) {
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IStatus status = ProjectWizardMainPage.validateName(ProjectWizardMainPage.this.projectName.getText());
                if (status != OK_STATUS) {
                    ProjectWizardMainPage.this.setErrorMessage(status.getMessage());
                } else {
                    ProjectWizardMainPage.this.setErrorMessage(null);
                }
            }
        });
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && this.validatePage();
    }

    private boolean validatePage() {
        IStatus status = ProjectWizardMainPage.validateName(this.projectName.getText());
        if (status != OK_STATUS) {
            this.contentFragment.specifyProjectDirectory.setEnabled(false);
            return false;
        }
        this.contentFragment.specifyProjectDirectory.setEnabled(true);
        if (!this.contentFragment.isValidateProjectLocation()) {
            return false;
        }
        Object o = ((IStructuredSelection)this.templateViewer.getSelection()).getFirstElement();
        if (o instanceof IProjectTemplate) {
            IProjectTemplate template = (IProjectTemplate)o;
            ProjectTemplateWizardNode cfr_ignored_0 = (ProjectTemplateWizardNode)template.getWizardNode();
            return true;
        }
        return false;
    }

    public static IStatus validateName(String name) {
        IResource variant;
        IStatus status = ProjectWizardMainPage.validateProjectName(name);
        if (!status.isOK()) {
            return status;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (project.exists()) {
            return ProjectWizardUtils.createErrorStatus(NewWizardMessages.error_project_already_exists);
        }
        if (!ProjectWizardUtils.isPlatformCaseSensitive() && (variant = ((Resource)project).findExistingResourceVariant(project.getFullPath())) != null) {
            return ProjectWizardUtils.createErrorStatus(NewWizardMessages.error_project_exists_different_case);
        }
        return OK_STATUS;
    }

    public static IStatus validateProjectName(String projectName) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        return workspace.validateName(projectName, 4);
    }

    public IStatus validatePackageName(String packageName) {
        if (packageName.length() > 0) {
            if (packageName.length() != packageName.trim().length()) {
                return ProjectWizardUtils.createErrorStatus(NewWizardMessages.error_basepackage_spaces);
            }
            StatusInfo pkgStatus = new StatusInfo();
            ICompilerOptions compilerOption = DefaultCompilerOptions.getInstance();
            EGLWizardUtilities.NameValidatorProblemRequestor nameValidaRequestor = new EGLWizardUtilities.NameValidatorProblemRequestor(pkgStatus);
            EGLNameValidator.validate((String)packageName, (int)30, (IProblemRequestor)nameValidaRequestor, (ICompilerOptions)compilerOption);
            if (!pkgStatus.isOK()) {
                return ProjectWizardUtils.createErrorStatus(pkgStatus.getMessage());
            }
        }
        return OK_STATUS;
    }

    public String getProjectName() {
        return this.projectName.getText();
    }

    public ProjectConfiguration getModel() {
        return this.model;
    }

    public void setProjectName(String projectName) {
        ((NewEGLProjectWizard)this.getWizard()).getModel().setProjectName(projectName);
    }

    protected IProjectTemplate[] getTemplates() {
        return ProjectTemplateManager.getInstance().getTemplates("org.eclipse.edt.ide.ui.projects");
    }

    private void setTemplateDescription(String text) {
        try {
            this.descriptionText.setText(text != null ? text : "");
        }
        catch (Exception exception) {
            this.descriptionText.setText("");
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        if (event.getSource() == this.templateViewer && this.isPageComplete()) {
            if (this.getSelectedNode() != null) {
                IWizard wiz = this.getWizard();
                IWizardContainer2 cfr_ignored_0 = (IWizardContainer2)wiz.getContainer();
                WizardDialog d = (WizardDialog)wiz.getContainer();
                d.showPage(this.getNextPage());
            } else if (this.getWizard().canFinish() && this.getWizard().performFinish()) {
                this.getWizard().getContainer().getShell().close();
            }
        }
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage() && this.validatePage();
    }

    private class TreeContentProvider
    implements IStructuredContentProvider {
        private TreeContentProvider() {
        }

        public Object[] getElements(Object input) {
            return (IProjectTemplate[])input;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class TreeLabelProvider
    implements ILabelProvider {
        public Image getImage(Object element) {
            if (element instanceof IProjectTemplate && ((IProjectTemplate)element).getIcon() != null) {
                return ((IProjectTemplate)element).getIcon().createImage();
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IProjectTemplate) {
                return ((IProjectTemplate)element).getName();
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

