/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.packageexplorer;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.dialogs.MoveDialog;
import org.eclipse.edt.ide.ui.internal.packageexplorer.MoveResourceAndFilesFolderOperation;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.actions.SelectionListenerAction;

public class MoveAction
extends SelectionListenerAction
implements IActionDelegate {
    private IStructuredSelection moveSelection;
    private IEGLElement EGLSelection = null;

    public MoveAction() {
        super(UINlsStrings.Move);
        this.updateSelection(this.getStructuredSelection());
    }

    public void run() {
        Shell theshell = new Shell(EDTUIPlugin.getActiveWorkbenchShell());
        MoveDialog moveDialog = new MoveDialog(theshell, this.EGLSelection);
        if (moveDialog.open() == 0) {
            Object destination = moveDialog.getFirstResult();
            for (IEGLElement specificSelection : this.moveSelection) {
                int eglType = specificSelection.getElementType();
                if (eglType == 6 && destination instanceof IPackageFragmentRoot) {
                    IPackageFragment defaultpkg = ((IPackageFragmentRoot)destination).getPackageFragment("");
                    destination = defaultpkg;
                }
                if (!(destination instanceof IEGLElement)) continue;
                MoveResourceAndFilesFolderOperation moveOp = new MoveResourceAndFilesFolderOperation(new IEGLElement[]{specificSelection}, new IEGLElement[]{(IEGLElement)destination}, false, theshell);
                try {
                    moveOp.run(null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.moveSelection = selection;
        Object firstElem = this.moveSelection.getFirstElement();
        if (firstElem instanceof IEGLElement) {
            this.EGLSelection = (IEGLElement)firstElem;
        }
        if (selection.size() > 1) {
            Class<?> firstElementType = firstElem.getClass();
            for (Object element : this.moveSelection) {
                if (this.isDefaultPackage(element)) {
                    return false;
                }
                if (element instanceof IPackageFragmentRoot) {
                    return false;
                }
                if (element instanceof IEGLFile) {
                    return false;
                }
                if (firstElementType.isInstance(element)) continue;
                return false;
            }
            return true;
        }
        if (firstElem instanceof IEGLFile) {
            return false;
        }
        if (firstElem instanceof IEGLElement) {
            if (this.isDefaultPackage(firstElem)) {
                return false;
            }
            return !(firstElem instanceof IPackageFragmentRoot);
        }
        return false;
    }

    private boolean isDefaultPackage(Object elem) {
        IPackageFragment pkg;
        return elem instanceof IPackageFragment && (pkg = (IPackageFragment)elem).isDefaultPackage();
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enable = this.updateSelection((IStructuredSelection)selection);
        action.setEnabled(enable);
    }
}

