/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.packageexplorer;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.edt.ide.core.internal.model.CopyResourceElementsOperation;
import org.eclipse.edt.ide.core.internal.model.EGLModelStatus;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLModelStatus;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.ui.internal.dialogs.RenameDialog;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.MoveFilesAndFoldersOperation;

public class CopyResourceAndFilesFolderOperation
extends CopyResourceElementsOperation {
    private Shell shell;

    public CopyResourceAndFilesFolderOperation(IEGLElement[] resourcesToCopy, IEGLElement[] destContainers, boolean force, Shell shell) {
        super(resourcesToCopy, destContainers, force);
        this.shell = shell;
    }

    public CopyResourceAndFilesFolderOperation(IEGLElement[] resourcesToCopy, IEGLElement destContainer, boolean force, Shell shell) {
        super(resourcesToCopy, destContainer, force);
        this.shell = shell;
    }

    protected void processElement(IEGLElement element) throws EGLModelException {
        IEGLElement dest = this.getDestinationParent(element);
        switch (element.getElementType()) {
            case 6: {
                this.processCompilationUnitResource((IEGLFile)element, (IPackageFragment)dest);
                this.fCreatedElements.add(((IPackageFragment)dest).getEGLFile(element.getElementName()));
                break;
            }
            case 4: {
                this.processPackageFragmentResource((IPackageFragment)element, (IPackageFragmentRoot)dest);
                break;
            }
            default: {
                throw new EGLModelException((IEGLModelStatus)new EGLModelStatus(967, element));
            }
        }
    }

    private void processCompilationUnitResource(IEGLFile source, IPackageFragment dest) throws EGLModelException {
        String newCUName = this.getNewNameFor((IEGLElement)source);
        String destName = newCUName != null ? newCUName : source.getElementName();
        IFile sourceResource = (IFile)(source.isWorkingCopy() ? source.getOriginalElement() : source).getResource();
        IContainer destFolder = (IContainer)dest.getResource();
        Object Op = null;
        Op = !this.isMove() ? new CopyFilesAndFoldersOperation(this.shell) : new MoveFilesAndFoldersOperation(this.shell);
        IResource[] copiedResource = Op.copyResources(new IResource[]{sourceResource}, destFolder);
        boolean isCopied = copiedResource.length > 0;
        IEGLFile destCU = dest.getEGLFile(destName);
        this.prepareDeltas((IEGLElement)source, (IEGLElement)destCU, this.isMove() && isCopied);
        if (newCUName != null) {
            String oldName = source.getElementName();
            oldName = oldName.substring(0, oldName.length() - 5);
            String newName = newCUName;
            newName = newName.substring(0, newName.length() - 5);
            this.prepareDeltas((IEGLElement)source.getPart(oldName), (IEGLElement)destCU.getPart(newName), this.isMove() && isCopied);
        }
    }

    private static String getAutoNewNameForPackageFragment(String originalName, IPackageFragmentRoot root) {
        int counter = 1;
        while (true) {
            String nameSegment = counter > 1 ? NewWizardMessages.bind((String)NewWizardMessages.EGLPasteConflictRenamepackageOneArg, (Object)new Integer(counter)) : NewWizardMessages.EGLPasteConflictRenamepackageNoArg;
            String nameToTry = String.valueOf(originalName) + nameSegment;
            if (!root.getPackageFragment(nameToTry).getResource().exists()) {
                return nameToTry;
            }
            ++counter;
        }
    }

    private IPackageFragment getNewPackageFragmentForConflictPackageFragment(final String sourcePkgName, final IPackageFragment newFrag, final IPackageFragmentRoot root) {
        final String[] returnValue = new String[]{""};
        this.shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                RenameDialog dialog = new RenameDialog(CopyResourceAndFilesFolderOperation.this.shell, "", NewWizardMessages.bind((String)NewWizardMessages.CopyFilesAndFoldersOperation_inputDialogMessage, (Object[])new String[]{sourcePkgName}), CopyResourceAndFilesFolderOperation.getAutoNewNameForPackageFragment(sourcePkgName, root), (IEGLElement)newFrag);
                dialog.setBlockOnOpen(true);
                dialog.open();
                returnValue[0] = dialog.getReturnCode() == 1 ? null : dialog.getValue();
            }
        });
        if (returnValue[0] == null) {
            throw new OperationCanceledException();
        }
        return root.getPackageFragment(returnValue[0]);
    }

    private void processPackageFragmentResource(IPackageFragment source, IPackageFragmentRoot root) throws EGLModelException {
        try {
            IResource[] copiedResources;
            IPackageFragment trynewFrag;
            String sourceName = source.getElementName();
            IPackageFragment newFrag = trynewFrag = root.getPackageFragment(sourceName);
            boolean askoverwirtefolder = false;
            if (newFrag.getResource().exists()) {
                if (source.getParent().equals(root)) {
                    newFrag = this.getNewPackageFragmentForConflictPackageFragment(sourceName, trynewFrag, root);
                } else {
                    askoverwirtefolder = true;
                }
            }
            this.createNeededPackageFragments((IContainer)source.getParent().getResource(), root, newFrag.getElementName(), this.isMove());
            Object Op = null;
            Op = !this.isMove() ? new CopyFilesAndFoldersOperation(this.shell) : new MoveFilesAndFoldersOperation(this.shell);
            if (askoverwirtefolder || this.isMove()) {
                copiedResources = Op.copyResources(new IResource[]{source.getResource()}, newFrag.getResource().getParent());
            } else {
                IContainer destFolder = (IContainer)newFrag.getResource();
                IResource[] childrenresources = this.collectResourcesOfInterest(source);
                copiedResources = Op.copyResources(childrenresources, destFolder);
            }
            if (copiedResources.length > 0) {
                this.prepareDeltas((IEGLElement)source, (IEGLElement)newFrag, this.isMove());
            }
        }
        catch (EGLModelException e) {
            throw e;
        }
        catch (OperationCanceledException operationCanceledException) {
            return;
        }
    }
}

