/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.outline;

import java.util.ArrayList;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Delegate;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.outline.AbstractOutlineAdapter;
import org.eclipse.jface.text.IRegion;

public class DelegateOutlineAdapter
extends AbstractOutlineAdapter {
    public DelegateOutlineAdapter(EGLEditor editor) {
        super(editor);
        this.nodeIcon = PluginImages.DESC_OBJS_DELEGATE;
    }

    @Override
    public String getText(Object element) {
        Delegate item = (Delegate)element;
        Name funcName = item.getName();
        StringBuffer buffer = new StringBuffer();
        buffer.append(funcName.getCanonicalName());
        buffer.append('(');
        final ArrayList parameters = new ArrayList();
        item.accept((IASTVisitor)new DefaultASTVisitor(){

            public boolean visit(Delegate delegate) {
                return true;
            }

            public boolean visit(FunctionParameter functionParameter) {
                parameters.add(functionParameter);
                return false;
            }
        });
        int len = parameters.size();
        if (len > 0) {
            int i = 0;
            while (i < len) {
                if (i != 0) {
                    buffer.append(", ");
                }
                FunctionParameter param = (FunctionParameter)parameters.get(i);
                buffer.append(this.formatType(param.getType()));
                ++i;
            }
        }
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public IRegion getHighlightRange(Object element) {
        Delegate node = (Delegate)element;
        return this.getPartNameHighlightRange((Part)node);
    }
}

