/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.libraries.wizards;

import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.libraries.wizards.LibraryConfiguration;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPartWizard;
import org.eclipse.edt.ide.ui.internal.wizards.EGLTemplateWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.templates.ITemplate;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class LibraryWizardPage
extends EGLTemplateWizardPage {
    protected Text descriptionText;
    private StatusInfo fLibraryStatus;

    public LibraryWizardPage(ISelection selection, String pageName) {
        super(pageName);
        this.setTitle(NewWizardMessages.NewEGLLibraryWizardPageTitle);
        this.setDescription(NewWizardMessages.NewEGLLibraryWizardPageDescription);
        this.fLibraryStatus = new StatusInfo();
    }

    @Override
    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, IUIHelpConstants.EGL_LIBRARY_DEFINITION);
        GridLayout layout = new GridLayout(5, false);
        container.setLayout((Layout)layout);
        this.createContainerControls(container, 5);
        this.createPackageControls(container);
        this.createSeparator(container, 5);
        this.createEGLFileControls(container);
        this.createTemplateArea(container, 5);
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
    }

    private void dialogChanged() {
    }

    @Override
    protected void handleEGLFileDialogFieldChanged() {
        super.handleEGLFileDialogFieldChanged();
        LibraryConfiguration config = (LibraryConfiguration)((EGLPartWizard)this.getWizard()).getConfiguration();
        String libName = config.getFileName();
        config.setLibraryName(libName);
    }

    @Override
    protected String getTemplateID() {
        return "org.eclipse.edt.ide.ui.libraries";
    }

    @Override
    protected void handleSelectedTemplate() {
        Object o;
        super.handleSelectedTemplate();
        if (this.templateViewer != null && (o = ((IStructuredSelection)this.templateViewer.getSelection()).getFirstElement()) instanceof ITemplate) {
            ITemplate template = (ITemplate)o;
            LibraryConfiguration config = (LibraryConfiguration)((EGLPartWizard)this.getWizard()).getConfiguration();
            config.setCodeTemplateId(template.getCodeTemplateId());
            config.setLibraryTypeByTemplateID(template.getId());
        }
    }
}

