/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.handlers.wizards;

import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.handlers.wizards.HandlerConfiguration;
import org.eclipse.edt.ide.ui.internal.handlers.wizards.RUIWidgetWizard;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IListAdapter;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.ListDialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class RUIWidgetWizardPage
extends WizardPage {
    private int nColumns = 5;
    private StringDialogField fWidgetDialogField;
    private StatusInfo fProgramStatus;
    protected boolean inputNeedsProcessing = true;
    private String widgetName;

    protected RUIWidgetWizardPage(String pageName) {
        super(pageName);
        this.setTitle(NewWizardMessages.NewEGLRUIWidgetWizardPageTitle);
        this.setDescription(NewWizardMessages.NewEGLRUIWidgetWizardPageDescription);
        this.fProgramStatus = new StatusInfo();
    }

    private void handleWidgetDialogFieldChanged() {
        this.widgetName = this.fWidgetDialogField.getText();
        this.validatePage();
    }

    private HandlerConfiguration getConfiguration() {
        return ((RUIWidgetWizard)this.getWizard()).getConfiguration();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IUIHelpConstants.EGL_RUI_WIDGET_DEFINITION);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = this.nColumns;
        composite.setLayout((Layout)layout);
        this.fWidgetDialogField = new StringDialogField();
        this.fWidgetDialogField.setDialogFieldListener(new HandlerDialogFieldAdapter());
        this.fWidgetDialogField.setLabelText(NewWizardMessages.NewEGLRUIWidgetWizardPagePartlabel);
        this.fWidgetDialogField.setEnabled(false);
        this.fWidgetDialogField.doFillIntoGrid(composite, this.nColumns - 1);
        DialogField.createEmptySpace(composite);
        LayoutUtil.setWidthHint((Control)this.fWidgetDialogField.getTextControl(null), this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)this.fWidgetDialogField.getTextControl(null));
        this.widgetName = this.getConfiguration().getHandlerName();
        this.fWidgetDialogField.setText(this.getConfiguration().getHandlerName());
        this.setControl((Control)composite);
        this.validatePage();
        Dialog.applyDialogFont((Control)parent);
    }

    protected boolean validatePage() {
        return true;
    }

    protected int getMaxFieldWidth() {
        return this.convertWidthInCharsToPixels(40);
    }

    public boolean isInputNeedsProcessing() {
        return this.inputNeedsProcessing;
    }

    public void setInputNeedsProcessing(boolean b) {
        this.inputNeedsProcessing = b;
    }

    public String getWidgetName() {
        return this.widgetName;
    }

    public void updateWidgetName() {
        this.fWidgetDialogField.setText(this.getConfiguration().getHandlerName());
    }

    private class HandlerDialogFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener,
    IListAdapter {
        private HandlerDialogFieldAdapter() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
        }

        @Override
        public void customButtonPressed(ListDialogField field, int index) {
        }

        @Override
        public void selectionChanged(ListDialogField field) {
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            RUIWidgetWizardPage.this.handleWidgetDialogFieldChanged();
        }

        @Override
        public void doubleClicked(ListDialogField field) {
        }
    }
}

