/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.handlers.wizards;

import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.handlers.wizards.HandlerConfiguration;
import org.eclipse.edt.ide.ui.internal.handlers.wizards.NewHandlerSummaryPage;
import org.eclipse.edt.ide.ui.internal.handlers.wizards.NewHandlerWizard;
import org.eclipse.edt.ide.ui.internal.handlers.wizards.RUIHandlerOperation;
import org.eclipse.edt.ide.ui.internal.handlers.wizards.RUIHandlerWizardPage;
import org.eclipse.edt.ide.ui.templates.wizards.TemplateWizard;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;

public class RUIHandlerWizard
extends TemplateWizard
implements IPageChangingListener {
    private static final String WIZPAGENAME_RUIHandlerWizardPage = "WIZPAGENAME_RUIHandlerWizardPage";
    protected RUIHandlerWizardPage inputPage;
    protected NewHandlerSummaryPage summaryPage;
    protected HandlerConfiguration configuration;
    protected String part;

    public RUIHandlerWizard() {
        this.setNeedsProgressMonitor(true);
        this.setDialogSettings(EDTUIPlugin.getDefault().getDialogSettings());
    }

    public HandlerConfiguration getConfiguration() {
        return (HandlerConfiguration)((NewHandlerWizard)this.getParentWizard()).getConfiguration();
    }

    public void addPages() {
        this.inputPage = new RUIHandlerWizardPage(WIZPAGENAME_RUIHandlerWizardPage);
        this.addPage((IWizardPage)this.inputPage);
        this.summaryPage = new NewHandlerSummaryPage();
        this.addPage((IWizardPage)this.summaryPage);
    }

    public void setContainer(IWizardContainer wizardContainer) {
        super.setContainer(wizardContainer);
        if (wizardContainer != null) {
            ((WizardDialog)wizardContainer).addPageChangingListener((IPageChangingListener)this);
        }
    }

    @Override
    public boolean performFinish() {
        if (this.inputPage == null) {
            this.processInput(this.getConfiguration().getHandlerName());
        } else if (this.inputPage.isInputNeedsProcessing()) {
            this.processInput(this.inputPage.getHandlerTitle());
        }
        this.getConfiguration().setHandlerType(1);
        if (this.part == null) {
            return false;
        }
        ((NewHandlerWizard)this.getParentWizard()).setContentObj(this.part);
        return true;
    }

    private void processInput(String handlerName) {
        RUIHandlerOperation op = new RUIHandlerOperation(this.getConfiguration(), handlerName);
        try {
            this.part = op.getFileContents();
            if (this.summaryPage != null) {
                this.summaryPage.setContent(this.part);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void handlePageChanging(PageChangingEvent event) {
        if (event.getCurrentPage() == this.inputPage && this.inputPage.isInputNeedsProcessing() && event.getTargetPage() == this.summaryPage) {
            this.processInput(this.inputPage.getHandlerTitle());
        } else if (event.getTargetPage() == this.inputPage) {
            this.inputPage.updateHandlerName();
        }
    }
}

