/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.formatting.ui;

import java.util.Collection;
import java.util.Map;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.formatting.profile.Category;
import org.eclipse.edt.ide.ui.internal.formatting.profile.DefaultProfile;
import org.eclipse.edt.ide.ui.internal.formatting.profile.Preference;
import org.eclipse.edt.ide.ui.internal.formatting.profile.ProfilePackage;
import org.eclipse.edt.ide.ui.internal.formatting.ui.ModifyDialog;
import org.eclipse.edt.ide.ui.internal.formatting.ui.ModifyDialogTabPage;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class LineWrappingTabPage
extends ModifyDialogTabPage {
    protected final IDialogSettings fDialogSettings = EDTUIPlugin.getDefault().getDialogSettings();
    private final WrappingNodeComponent fWrappingComponent = new WrappingNodeComponent();
    private static final int COLINDEX_EGLELEM = 0;
    private static final int COLINDEX_WRAPPOLICY = 1;

    public LineWrappingTabPage(ModifyDialog modifyDialog, DefaultProfile defaultProfile, Category category, Map allPreferenceSettings) {
        super(modifyDialog, defaultProfile, category, allPreferenceSettings);
    }

    @Override
    protected void initializePage() {
        this.fWrappingComponent.initialize();
    }

    @Override
    protected void createTreePref(Preference pref) {
        this.fWrappingComponent.populatePreferenceMapData(pref, ProfilePackage.eINSTANCE.getPreference_Display());
    }

    @Override
    protected ModifyDialogTabPage.ComboPreference createComboPref(Composite composite, int numColumns, String labelText, String categoryID, String prefID, String[] values, String[] items, String previewTextPerPreference) {
        this.fWrappingComponent.createContents(numColumns, composite);
        ModifyDialogTabPage.ComboPreference comboPref = super.createComboPref(composite, numColumns, labelText, categoryID, prefID, values, items, previewTextPerPreference);
        this.fWrappingComponent.setComboPreference((Combo)comboPref.getControl(), comboPref.getLabel());
        return comboPref;
    }

    protected class OptionTreeMultiColumnLabelProvider
    extends ModifyDialogTabPage.OptionTreeLabelProvider
    implements ITableLabelProvider {
        private String[] fAllWrappingPolicys = null;

        public OptionTreeMultiColumnLabelProvider(String[] wrappingPolicyChoices) {
            this.fAllWrappingPolicys = wrappingPolicyChoices;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.getText(element);
            }
            if (columnIndex == 1 && element instanceof ModifyDialogTabPage.OptionLeafNode) {
                String strWrappingPolicy = LineWrappingTabPage.this.getCurrentValue(((ModifyDialogTabPage.OptionLeafNode)element).fPreferenceKey);
                int wrappingPolicy = Integer.parseInt(strWrappingPolicy);
                if (this.fAllWrappingPolicys != null) {
                    return this.fAllWrappingPolicys[wrappingPolicy];
                }
            }
            return "";
        }
    }

    private class WrappingNodeComponent
    extends ModifyDialogTabPage.TreeControlPreference {
        private static final String PREF_Wrapping_KEY = "org.eclipse.edt.ide.uiformatter_page.line_wrapping_tab_page.node";
        private final String[] HEADER_TITLES;
        private Combo fCombo;
        private Label fComboLabel;
        private String fInitialComboLabel;
        public static final int DEFAULT_COLUMN_WIDTH = 80;

        protected WrappingNodeComponent() {
            super(LineWrappingTabPage.this, LineWrappingTabPage.this.fDialogSettings, PREF_Wrapping_KEY);
            this.HEADER_TITLES = new String[]{NewWizardMessages.Col_EGLLang, NewWizardMessages.Col_CurrWrappingPolicy};
            this.fCombo = null;
            this.fComboLabel = null;
        }

        @Override
        protected TreeViewer createTreeViewer(Composite composite, int numColumns) {
            TreeViewer treeViewer = new TreeViewer(composite, 68098);
            Tree tree = treeViewer.getTree();
            tree.setLinesVisible(true);
            tree.setHeaderVisible(true);
            TableLayout tableLayout = new TableLayout();
            int maxWidth = 80;
            TreeColumn treeColumn = new TreeColumn(tree, 16384, 0);
            treeColumn.setText(this.HEADER_TITLES[0]);
            treeColumn.pack();
            int treeColWidth = Math.max(80, treeColumn.getWidth());
            maxWidth = Math.max(maxWidth, treeColWidth);
            ColumnWeightData colData = new ColumnWeightData(treeColWidth, treeColWidth, true);
            tableLayout.addColumnData((ColumnLayoutData)colData);
            treeColumn = new TreeColumn(tree, 16384, 1);
            treeColumn.setText(this.HEADER_TITLES[1]);
            treeColumn.pack();
            treeColWidth = Math.max(80, treeColumn.getWidth());
            maxWidth = Math.max(maxWidth, treeColWidth);
            colData = new ColumnWeightData(treeColWidth, treeColWidth, true);
            tableLayout.addColumnData((ColumnLayoutData)colData);
            tree.setLayout((Layout)tableLayout);
            return treeViewer;
        }

        @Override
        protected void createContents(int numColumns, Composite parent) {
            super.createContents(numColumns, parent);
            GridData gd = (GridData)this.fTreeViewer.getControl().getLayoutData();
            gd.heightHint = 250;
            gd.horizontalAlignment = 4;
            this.fTreeViewer.getControl().setLayoutData((Object)gd);
        }

        @Override
        public void initialize() {
            this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WrappingNodeComponent.this.comboSelected(((Combo)e.widget).getSelectionIndex());
                }
            });
            this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new OptionTreeMultiColumnLabelProvider(this.fCombo.getItems()));
            super.initialize();
            if (this.fLastSelected instanceof ModifyDialogTabPage.OptionTreeNode) {
                this.fTreeViewer.setExpandedElements(new Object[]{this.fLastSelected});
            }
        }

        protected void comboSelected(int selectionIndex) {
            IStructuredSelection sels = (IStructuredSelection)this.fTreeViewer.getSelection();
            this.setWrappingPolicyValue(sels.toList(), selectionIndex);
            this.fTreeViewer.refresh();
            LineWrappingTabPage.this.doUpdatePreview();
            LineWrappingTabPage.this.notifyValuesModified();
        }

        private void setWrappingPolicyValue(Collection nodes, int wrappingPolicy) {
            if (nodes != null) {
                for (Object node : nodes) {
                    if (node instanceof ModifyDialogTabPage.OptionTreeNode) {
                        ModifyDialogTabPage.OptionTreeNode treeNode = (ModifyDialogTabPage.OptionTreeNode)node;
                        this.setWrappingPolicyValue(treeNode.getChildren().values(), wrappingPolicy);
                        continue;
                    }
                    if (!(node instanceof ModifyDialogTabPage.OptionLeafNode)) continue;
                    ModifyDialogTabPage.OptionLeafNode leafNode = (ModifyDialogTabPage.OptionLeafNode)node;
                    LineWrappingTabPage.this.setCurrentValue(leafNode.fPreferenceKey, Integer.toString(wrappingPolicy));
                }
            }
        }

        public void setComboPreference(Combo combo, Label label) {
            this.fCombo = combo;
            this.fComboLabel = label;
            this.fInitialComboLabel = label.getText();
        }

        @Override
        public void selectionChanged(SelectionChangedEvent event) {
            super.selectionChanged(event);
            if (!event.getSelection().isEmpty() && this.fLastSelected != null) {
                if (this.fLastSelected instanceof ModifyDialogTabPage.OptionLeafNode) {
                    ModifyDialogTabPage.OptionLeafNode node = (ModifyDialogTabPage.OptionLeafNode)this.fLastSelected;
                    String currWrappingPolicy = LineWrappingTabPage.this.getCurrentValue(node.fPreferenceKey);
                    this.fCombo.select(Integer.parseInt(currWrappingPolicy));
                    this.fComboLabel.setText(NewWizardMessages.bind((String)NewWizardMessages.LineWrappingSettingFor, (Object)node.fDisplay));
                } else {
                    this.fComboLabel.setText(this.fInitialComboLabel);
                }
            }
        }
    }
}

