/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.formatting.ui;

import java.io.File;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.formatting.profile.Profile;
import org.eclipse.edt.ide.ui.internal.formatting.ui.AlreadyExistsDialog;
import org.eclipse.edt.ide.ui.internal.formatting.ui.CreateProfileDialog;
import org.eclipse.edt.ide.ui.internal.formatting.ui.EGLPreview;
import org.eclipse.edt.ide.ui.internal.formatting.ui.ModifyDialog;
import org.eclipse.edt.ide.ui.internal.formatting.ui.ProfileManager;
import org.eclipse.edt.ide.ui.internal.formatting.ui.RenameProfileDialog;
import org.eclipse.edt.ide.ui.internal.util.PixelConverter;
import org.eclipse.edt.ide.ui.internal.util.SWTUtil;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CodeFormatterConfigurationBlock {
    private static final String DIALOGSTORE_LASTIMPORTPATH = "org.eclipse.edt.ide.ui.codeformatter.importpath";
    private static final String DIALOGSTORE_LASTEXPORTPATH = "org.eclipse.edt.ide.ui.codeformatter.exportpath";
    protected Composite fComposite;
    protected Combo fProfileCombo;
    protected Button fEditButton;
    protected Button fRenameButton;
    protected Button fDeleteButton;
    protected Button fNewButton;
    protected Button fLoadButton;
    protected Button fSaveButton;
    protected EGLPreview fEGLPreview;
    private PixelConverter fPixConv;
    protected final ProfileManager fProfileManager = ProfileManager.getInstance();
    private ButtonController fBtnController;
    private ProfileComboController fComboController;
    private PreviewController fPreviewController;

    public CodeFormatterConfigurationBlock(IProject project) {
    }

    public Composite createContents(Composite parent) {
        this.fPixConv = new PixelConverter((Control)parent);
        this.fComposite = this.createComposite(parent, 5);
        this.fProfileCombo = CodeFormatterConfigurationBlock.createProfileCombo(this.fComposite, 2, this.fPixConv.convertWidthInCharsToPixels(20));
        this.fEditButton = CodeFormatterConfigurationBlock.createButton(this.fComposite, NewWizardMessages.Edit, 32);
        this.fRenameButton = CodeFormatterConfigurationBlock.createButton(this.fComposite, NewWizardMessages.Rename, 32);
        this.fDeleteButton = CodeFormatterConfigurationBlock.createButton(this.fComposite, NewWizardMessages.Remove, 32);
        Composite group = this.createComposite(this.fComposite, 4);
        GridData groupData = new GridData(256);
        groupData.horizontalSpan = 5;
        group.setLayoutData((Object)groupData);
        this.fNewButton = CodeFormatterConfigurationBlock.createButton(group, NewWizardMessages.New, 32);
        ((GridData)CodeFormatterConfigurationBlock.createLabel((Composite)group, (String)"", (int)1).getLayoutData()).grabExcessHorizontalSpace = true;
        this.fLoadButton = CodeFormatterConfigurationBlock.createButton(group, NewWizardMessages.Import, 128);
        this.fSaveButton = CodeFormatterConfigurationBlock.createButton(group, NewWizardMessages.Export, 128);
        CodeFormatterConfigurationBlock.createLabel(this.fComposite, NewWizardMessages.Preview, 5);
        this.configurePreview(this.fComposite, 5);
        this.fBtnController = new ButtonController();
        this.fComboController = new ProfileComboController();
        this.fPreviewController = new PreviewController();
        return this.fComposite;
    }

    public void dispose() {
        if (this.fBtnController != null) {
            this.fBtnController.dispose();
        }
        if (this.fComboController != null) {
            this.fComboController.dispose();
        }
        if (this.fPreviewController != null) {
            this.fPreviewController.dispose();
        }
        if (this.fEGLPreview != null) {
            this.fEGLPreview.dispose();
        }
    }

    private static Button createButton(Composite composite, String text, int style) {
        Button button = new Button(composite, 8);
        button.setFont(composite.getFont());
        button.setText(text);
        GridData gd = new GridData(style);
        gd.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gd);
        return button;
    }

    private static Combo createProfileCombo(Composite composite, int span, int widthHint) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        gd.widthHint = widthHint;
        Combo combo = new Combo(composite, 12);
        combo.setFont(composite.getFont());
        combo.setLayoutData((Object)gd);
        return combo;
    }

    private static Label createLabel(Composite composite, String text, int numColumns) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = numColumns;
        gd.widthHint = 0;
        Label label = new Label(composite, 64);
        label.setFont(composite.getFont());
        label.setText(text);
        label.setLayoutData((Object)gd);
        return label;
    }

    private Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout(numColumns, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        return composite;
    }

    private void configurePreview(Composite composite, int numColumns) {
        this.fEGLPreview = new EGLPreview(composite, this.fProfileManager.getCurrentPreferenceSettingMap());
        this.fEGLPreview.setPreviewText(this.fProfileManager.getDefaultPreviewCode());
        GridData gd = new GridData(1296);
        gd.horizontalSpan = numColumns;
        gd.verticalSpan = 7;
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.fEGLPreview.getControl().setLayoutData((Object)gd);
    }

    public final boolean hasProjectSpecificOptions(IProject project) {
        return false;
    }

    public boolean performOk() {
        this.performApply();
        return true;
    }

    public void performApply() {
        this.fProfileManager.saveCustomWorkspaceFormatProfile(true);
    }

    public void performDefaults() {
        this.fProfileManager.setSelectedProfile(0);
    }

    public boolean performCancel() {
        this.fProfileManager.clearCachedModel(true);
        return false;
    }

    private class ButtonController
    implements Observer,
    SelectionListener {
        public ButtonController() {
            CodeFormatterConfigurationBlock.this.fProfileManager.addObserver(this);
            CodeFormatterConfigurationBlock.this.fNewButton.addSelectionListener((SelectionListener)this);
            CodeFormatterConfigurationBlock.this.fRenameButton.addSelectionListener((SelectionListener)this);
            CodeFormatterConfigurationBlock.this.fEditButton.addSelectionListener((SelectionListener)this);
            CodeFormatterConfigurationBlock.this.fDeleteButton.addSelectionListener((SelectionListener)this);
            CodeFormatterConfigurationBlock.this.fSaveButton.addSelectionListener((SelectionListener)this);
            CodeFormatterConfigurationBlock.this.fLoadButton.addSelectionListener((SelectionListener)this);
            this.update(CodeFormatterConfigurationBlock.this.fProfileManager, null);
        }

        @Override
        public void update(Observable o, Object arg) {
            ProfileManager profileManager = (ProfileManager)o;
            boolean isBuildIn = profileManager.isSelectedProfileBuildIn();
            CodeFormatterConfigurationBlock.this.fEditButton.setText(isBuildIn ? NewWizardMessages.Show : NewWizardMessages.Edit);
            CodeFormatterConfigurationBlock.this.fDeleteButton.setEnabled(!isBuildIn);
            CodeFormatterConfigurationBlock.this.fSaveButton.setEnabled(!isBuildIn);
            CodeFormatterConfigurationBlock.this.fRenameButton.setEnabled(!isBuildIn);
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            if (button == CodeFormatterConfigurationBlock.this.fSaveButton) {
                this.exportButtonPressed();
            } else if (button == CodeFormatterConfigurationBlock.this.fEditButton) {
                this.modifyButtonPressed();
            } else if (button == CodeFormatterConfigurationBlock.this.fDeleteButton) {
                this.deleteButtonPressed();
            } else if (button == CodeFormatterConfigurationBlock.this.fNewButton) {
                this.newButtonPressed();
            } else if (button == CodeFormatterConfigurationBlock.this.fLoadButton) {
                this.importButtonPressed();
            } else if (button == CodeFormatterConfigurationBlock.this.fRenameButton) {
                this.renameButtonPressed();
            }
        }

        private void renameButtonPressed() {
            if (CodeFormatterConfigurationBlock.this.fProfileManager.isSelectedProfileBuildIn()) {
                return;
            }
            Profile profile = (Profile)CodeFormatterConfigurationBlock.this.fProfileManager.getSelectedProfile();
            RenameProfileDialog renameDialog = new RenameProfileDialog(CodeFormatterConfigurationBlock.this.fComposite.getShell(), NewWizardMessages.RenameFormatProfile, profile, CodeFormatterConfigurationBlock.this.fProfileManager);
            if (renameDialog.open() == 0) {
                CodeFormatterConfigurationBlock.this.fProfileManager.setSelectedProfile(CodeFormatterConfigurationBlock.this.fProfileCombo.getSelectionIndex());
                CodeFormatterConfigurationBlock.this.fProfileManager.profileRenamed();
            }
        }

        private void importButtonPressed() {
            AlreadyExistsDialog aeDlg;
            String importedProfileName;
            Profile importedProfile;
            block11: {
                String path;
                FileDialog filedlg = new FileDialog(CodeFormatterConfigurationBlock.this.fComposite.getShell(), 4096);
                filedlg.setText(NewWizardMessages.ImportFormatProfile);
                filedlg.setFilterExtensions(new String[]{"*.xml"});
                String lastPath = EDTUIPlugin.getDefault().getDialogSettings().get(CodeFormatterConfigurationBlock.DIALOGSTORE_LASTIMPORTPATH);
                if (lastPath != null) {
                    filedlg.setFilterPath(lastPath);
                }
                if ((path = filedlg.open()) == null) {
                    return;
                }
                EDTUIPlugin.getDefault().getDialogSettings().put(CodeFormatterConfigurationBlock.DIALOGSTORE_LASTEXPORTPATH, filedlg.getFilterPath());
                File file = new File(path);
                importedProfile = null;
                try {
                    try {
                        importedProfile = CodeFormatterConfigurationBlock.this.fProfileManager.getFirstProfileByParsing(file);
                    }
                    catch (RuntimeException runtimeException) {
                        if (importedProfile == null) {
                            MessageDialog.openError((Shell)CodeFormatterConfigurationBlock.this.fComposite.getShell(), (String)NewWizardMessages.ImportFormatProfile, (String)NewWizardMessages.bind((String)NewWizardMessages.Err_InvalidImportedFormatProfile, (Object)path));
                            return;
                        }
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    if (importedProfile == null) {
                        MessageDialog.openError((Shell)CodeFormatterConfigurationBlock.this.fComposite.getShell(), (String)NewWizardMessages.ImportFormatProfile, (String)NewWizardMessages.bind((String)NewWizardMessages.Err_InvalidImportedFormatProfile, (Object)path));
                        return;
                    }
                    throw throwable;
                }
                if (importedProfile == null) {
                    MessageDialog.openError((Shell)CodeFormatterConfigurationBlock.this.fComposite.getShell(), (String)NewWizardMessages.ImportFormatProfile, (String)NewWizardMessages.bind((String)NewWizardMessages.Err_InvalidImportedFormatProfile, (Object)path));
                    return;
                }
            }
            if (CodeFormatterConfigurationBlock.this.fProfileManager.containsProfile(importedProfileName = importedProfile.getName()) && (aeDlg = new AlreadyExistsDialog(CodeFormatterConfigurationBlock.this.fComposite.getShell(), importedProfile, CodeFormatterConfigurationBlock.this.fProfileManager)).open() != 0) {
                return;
            }
            CodeFormatterConfigurationBlock.this.fProfileManager.addProfile(importedProfile, true);
        }

        private void newButtonPressed() {
            CreateProfileDialog p = new CreateProfileDialog(CodeFormatterConfigurationBlock.this.fComposite.getShell(), CodeFormatterConfigurationBlock.this.fProfileManager);
            if (p.open() != 0) {
                return;
            }
            if (!p.openEditDialog()) {
                return;
            }
            ModifyDialog modifyDialog = new ModifyDialog(CodeFormatterConfigurationBlock.this.fComposite.getShell(), p.getCreatedProfile(), CodeFormatterConfigurationBlock.this.fProfileManager, true);
            modifyDialog.open();
        }

        private void deleteButtonPressed() {
            if (CodeFormatterConfigurationBlock.this.fProfileManager.isSelectedProfileBuildIn()) {
                return;
            }
            if (MessageDialog.openQuestion((Shell)CodeFormatterConfigurationBlock.this.fComposite.getShell(), (String)NewWizardMessages.ConfirmRemove, (String)NewWizardMessages.bind((String)NewWizardMessages.Q_ConfirmRemoveProfile, (Object)CodeFormatterConfigurationBlock.this.fProfileManager.getSelectedProfileDisplayName()))) {
                CodeFormatterConfigurationBlock.this.fProfileManager.deleteProfile(CodeFormatterConfigurationBlock.this.fProfileCombo.getSelectionIndex(), true);
            }
        }

        private void modifyButtonPressed() {
            ModifyDialog modifyDialog = new ModifyDialog(CodeFormatterConfigurationBlock.this.fComposite.getShell(), CodeFormatterConfigurationBlock.this.fProfileManager.getSelectedProfile(), CodeFormatterConfigurationBlock.this.fProfileManager, false);
            modifyDialog.open();
        }

        private void exportButtonPressed() {
            String path;
            FileDialog filedlg = new FileDialog(CodeFormatterConfigurationBlock.this.fComposite.getShell(), 8192);
            filedlg.setText(NewWizardMessages.ExportFormatProfile);
            filedlg.setFilterExtensions(new String[]{"*.xml"});
            String lastPath = EDTUIPlugin.getDefault().getDialogSettings().get(CodeFormatterConfigurationBlock.DIALOGSTORE_LASTEXPORTPATH);
            if (lastPath != null) {
                filedlg.setFilterPath(lastPath);
            }
            if ((path = filedlg.open()) == null) {
                return;
            }
            EDTUIPlugin.getDefault().getDialogSettings().put(CodeFormatterConfigurationBlock.DIALOGSTORE_LASTEXPORTPATH, filedlg.getFilterPath());
            File file = new File(path);
            if (file.exists() && !MessageDialog.openQuestion((Shell)CodeFormatterConfigurationBlock.this.fComposite.getShell(), (String)NewWizardMessages.ExportFormatProfile, (String)NewWizardMessages.bind((String)NewWizardMessages.Q_ReplaceExportedFormatProfile, (Object)path))) {
                return;
            }
            CodeFormatterConfigurationBlock.this.fProfileManager.exportSelectedProfile(file);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void dispose() {
            CodeFormatterConfigurationBlock.this.fProfileManager.deleteObserver(this);
            CodeFormatterConfigurationBlock.this.fNewButton.removeSelectionListener((SelectionListener)this);
            CodeFormatterConfigurationBlock.this.fRenameButton.removeSelectionListener((SelectionListener)this);
            CodeFormatterConfigurationBlock.this.fEditButton.removeSelectionListener((SelectionListener)this);
            CodeFormatterConfigurationBlock.this.fDeleteButton.removeSelectionListener((SelectionListener)this);
            CodeFormatterConfigurationBlock.this.fSaveButton.removeSelectionListener((SelectionListener)this);
            CodeFormatterConfigurationBlock.this.fLoadButton.removeSelectionListener((SelectionListener)this);
        }
    }

    private class PreviewController
    implements Observer {
        public PreviewController() {
            CodeFormatterConfigurationBlock.this.fProfileManager.addObserver(this);
            CodeFormatterConfigurationBlock.this.fEGLPreview.update();
        }

        @Override
        public void update(Observable o, Object arg) {
            int value = (Integer)arg;
            switch (value) {
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    CodeFormatterConfigurationBlock.this.fEGLPreview.update();
                }
            }
        }

        public void dispose() {
            CodeFormatterConfigurationBlock.this.fProfileManager.deleteObserver(this);
        }
    }

    private class ProfileComboController
    implements Observer,
    SelectionListener {
        public ProfileComboController() {
            CodeFormatterConfigurationBlock.this.fProfileCombo.addSelectionListener((SelectionListener)this);
            CodeFormatterConfigurationBlock.this.fProfileManager.addObserver(this);
            this.updateProfiles();
            this.updateSelection();
        }

        public void widgetSelected(SelectionEvent e) {
            int index = CodeFormatterConfigurationBlock.this.fProfileCombo.getSelectionIndex();
            CodeFormatterConfigurationBlock.this.fProfileManager.setSelectedProfile(index);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        @Override
        public void update(Observable o, Object arg) {
            if (arg == null) {
                return;
            }
            int value = (Integer)arg;
            switch (value) {
                case 2: 
                case 3: 
                case 4: {
                    this.updateProfiles();
                    this.updateSelection();
                    break;
                }
                case 1: {
                    this.updateSelection();
                }
            }
        }

        private void updateProfiles() {
            CodeFormatterConfigurationBlock.this.fProfileCombo.setItems(CodeFormatterConfigurationBlock.this.fProfileManager.getAllProfileDisplayNames());
        }

        private void updateSelection() {
            CodeFormatterConfigurationBlock.this.fProfileCombo.setText(CodeFormatterConfigurationBlock.this.fProfileManager.getSelectedProfileDisplayName());
        }

        public void dispose() {
            CodeFormatterConfigurationBlock.this.fProfileCombo.removeSelectionListener((SelectionListener)this);
            CodeFormatterConfigurationBlock.this.fProfileManager.deleteObserver(this);
        }
    }
}

