/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.formatting;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.edt.compiler.core.ast.AccumulatingSyntaxErrorMessageRequestor;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.ISyntaxErrorRequestor;
import org.eclipse.edt.compiler.core.ast.SyntaxError;
import org.eclipse.edt.ide.ui.editor.CodeFormatter;
import org.eclipse.edt.ide.ui.internal.formatting.CodeFormatterVisitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;

public class EGLCodeFormatter
extends CodeFormatter {
    private Map fPreferenceSetting;
    private static final String CONSOLE_FORMATTING = "EGL Formatting";

    public EGLCodeFormatter() {
    }

    public EGLCodeFormatter(Map options) {
        this();
        this.fPreferenceSetting = options;
    }

    @Override
    public TextEdit format(IDocument document, int offset, int length, int initialIndentationLevel, String lineSeparator, ISyntaxErrorRequestor syntxErrRequestor) {
        if (offset < 0 || length < 0) {
            throw new IllegalArgumentException();
        }
        CodeFormatterVisitor formatVisitor = new CodeFormatterVisitor(this.fPreferenceSetting, document, offset, length, initialIndentationLevel, lineSeparator);
        File fileAST = this.getFileAST(document);
        if (fileAST != null) {
            boolean hasSyntaxError;
            boolean callerPassInNullSyntaxErrRequestor = false;
            if (syntxErrRequestor == null) {
                syntxErrRequestor = new AccumulatingSyntaxErrorMessageRequestor();
                callerPassInNullSyntaxErrRequestor = true;
            }
            if (!(hasSyntaxError = fileAST.accept(syntxErrRequestor))) {
                return formatVisitor.format(fileAST);
            }
            if (callerPassInNullSyntaxErrRequestor && syntxErrRequestor instanceof AccumulatingSyntaxErrorMessageRequestor) {
                AccumulatingSyntaxErrorMessageRequestor errRequetor = (AccumulatingSyntaxErrorMessageRequestor)syntxErrRequestor;
                Map syntaxErrMsgs = errRequetor.getSyntaxErrors();
                Set keyset = syntaxErrMsgs.keySet();
                Iterator it = keyset.iterator();
                while (it.hasNext()) {
                    try {
                        SyntaxError syntaxErr = (SyntaxError)it.next();
                        String errmsg = (String)syntaxErrMsgs.get(syntaxErr);
                        int lineNum = document.getLineOfOffset(syntaxErr.startOffset);
                        String errToken = document.get(syntaxErr.startOffset, syntaxErr.endOffset - syntaxErr.startOffset);
                        System.out.println("Found syntax error: " + errmsg);
                        System.out.println("at line: " + (lineNum + 1) + " for token: " + errToken);
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    private MessageConsole findFormattingErrorConsole() {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMgr = plugin.getConsoleManager();
        IConsole[] existing = conMgr.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (CONSOLE_FORMATTING.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole formattingConsole = new MessageConsole(CONSOLE_FORMATTING, null);
        conMgr.addConsoles(new IConsole[]{formattingConsole});
        return formattingConsole;
    }
}

