/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.eglarpackager;

import java.io.IOException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.edt.compiler.internal.eglar.EglarManifest;
import org.eclipse.edt.ide.ui.internal.eglarpackager.AbstractEglarBinaryProjectBuilder;
import org.eclipse.edt.ide.ui.internal.eglarpackager.EglarPackageData;
import org.eclipse.edt.ide.ui.internal.eglarpackager.EglarUtility;
import org.eclipse.edt.ide.ui.internal.eglarpackager.EglarWriterUtility;
import org.eclipse.swt.widgets.Shell;

public class PlainEglarBuilder
extends AbstractEglarBinaryProjectBuilder {
    private static final String FOLDER_SLASH = "/";
    private static final String JAR_FILE_EXTENSION = ".jar";
    public static final String BUILDER_ID = "com.ibm.etools.egl.internal.ui.eglarpackager.PlainEglarBuilder";
    private EglarPackageData fEglarPackage;
    private EglarWriterUtility fEglarWriter;

    @Override
    public String getId() {
        return BUILDER_ID;
    }

    @Override
    public void open(EglarPackageData eglarPackage, Shell displayShell, MultiStatus statusMsg) throws CoreException {
        super.open(eglarPackage, displayShell, statusMsg);
        this.fEglarPackage = eglarPackage;
        this.fEglarWriter = new EglarWriterUtility(this.fEglarPackage, displayShell);
    }

    @Override
    public void writeFile(IFile resource, IPath destinationPath) throws CoreException {
        this.fEglarWriter.write(resource, destinationPath);
    }

    @Override
    public void writeArchive(ZipFile archiveRoot, IProgressMonitor progressMonitor) {
    }

    @Override
    public void close() throws CoreException {
        if (this.fEglarWriter != null) {
            this.fEglarWriter.close();
        }
    }

    @Override
    public void writeEGLSourceFile(IFile resource, IPath destinationPath) throws CoreException {
        this.fEglarWriter.write(resource, destinationPath);
    }

    @Override
    public void writeFolder(IResource folderResource, IPath destinationPath) throws CoreException {
        try {
            if (folderResource instanceof IProject) {
                String projectName = ((IProject)folderResource).getName();
                EglarManifest eglarManifest = new EglarManifest();
                eglarManifest.setVendor(this.fEglarPackage.getVendorName());
                eglarManifest.setVersion(this.fEglarPackage.getVersionName());
                IResource[] resources = EglarUtility.getGeneratedJavaClassFolder((IProject)folderResource);
                if (resources != null && resources.length > 0) {
                    int i = 0;
                    while (i < resources.length) {
                        if (resources[i].exists() && ((IFolder)resources[i]).members().length > 0) {
                            eglarManifest.setJavaJars("Java_Jars/" + projectName + JAR_FILE_EXTENSION);
                            break;
                        }
                        ++i;
                    }
                }
                this.fEglarWriter.addManifest(eglarManifest);
            } else if (folderResource instanceof IFolder) {
                this.fEglarWriter.addDirectories(destinationPath);
            }
        }
        catch (IOException e) {
            EglarWriterUtility.handleGeneralEglarException(folderResource.getFullPath(), e);
        }
    }

    @Override
    public void changeFolderTimeStamp(long oldTimeStamp, IPath destinationPath) throws CoreException {
    }

    @Override
    public void writeFileFromBytes(byte[] fileContent, IPath destinationPath) throws CoreException {
        this.fEglarWriter.addFileByBytes(fileContent, destinationPath);
    }
}

