/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java_cup.runtime.Scanner;
import org.eclipse.core.resources.IFile;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.ErrorCorrectingParser;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Lexer;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.ide.core.internal.model.BufferManager;
import org.eclipse.edt.ide.core.model.IBuffer;
import org.eclipse.edt.ide.core.model.IBufferFactory;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.ui.internal.editor.DocumentAdapter;
import org.eclipse.jface.text.IDocument;

public class EGLModelUtility {
    public static Node getNestedPartNode(IEGLDocument document, final int documentOffset) {
        File fileAST = document.getNewModelEGLFile();
        final Node[] newNestedNode = new Node[1];
        fileAST.accept((IASTVisitor)new AbstractASTVisitor(){

            public boolean visit(NestedFunction nestedFunction) {
                this.visitNestedPart((Node)nestedFunction);
                return false;
            }

            private void visitNestedPart(Node nestedNode) {
                if (documentOffset >= nestedNode.getOffset() && documentOffset <= nestedNode.getOffset() + nestedNode.getLength()) {
                    newNestedNode[0] = nestedNode;
                }
            }
        });
        return newNestedNode[0];
    }

    public static Part getPartNode(IEGLDocument document, int documentOffset) {
        Part eglPart2 = null;
        List eglParts = document.getNewModelEGLFile().getParts();
        for (Part eglPart2 : eglParts) {
            int offset = eglPart2.getOffset();
            int length = eglPart2.getLength();
            if (documentOffset < offset) {
                return null;
            }
            if (documentOffset < offset || documentOffset > offset + length) continue;
            return eglPart2;
        }
        return null;
    }

    public static File getEGLFileAST(IEGLFile eglfile, IBufferFactory factory) throws Exception {
        IEGLFile workingCopy = null;
        try {
            IDocument doc;
            IBuffer buf;
            if (factory == null) {
                factory = BufferManager.getDefaultBufferManager().getDefaultBufferFactory();
            }
            if ((buf = (workingCopy = (IEGLFile)eglfile.getSharedWorkingCopy(null, factory, null)).getBuffer()).hasUnsavedChanges()) {
                File fileRootNode;
                IFile file = (IFile)eglfile.getUnderlyingResource();
                int whitespacemask = 14;
                BufferedReader reader = new BufferedReader(new InputStreamReader(file.getContents(true), file.getCharset()));
                ErrorCorrectingParser newParser = new ErrorCorrectingParser((Scanner)new Lexer((Reader)reader), whitespacemask);
                File file2 = fileRootNode = (File)newParser.parse().value;
                return file2;
            }
            if (buf instanceof DocumentAdapter && (doc = ((DocumentAdapter)buf).getDocument()) instanceof IEGLDocument) {
                IEGLDocument egldoc = (IEGLDocument)doc;
                File file = egldoc.getNewModelEGLFile();
                return file;
            }
        }
        finally {
            if (workingCopy != null) {
                workingCopy.destroy();
            }
        }
        return null;
    }
}

