/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor.sql;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.editor.sql.SQLResultsListViewer;
import org.eclipse.edt.ide.ui.internal.results.views.AbstractResultsViewPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class SQLResultsViewPart
extends AbstractResultsViewPart
implements ISelectionChangedListener,
IDoubleClickListener {
    public static final String EGL_SQL_RESULTS_VIEWER = "org.eclipse.edit.ide.ui.sql.view.SQLResultsViewPart";

    @Override
    public int addNewViewer(String tabTitle, List problems, Object resultsIdentifier, IAction reSyntaxCheckAction) {
        ViewForm viewForm = new ViewForm((Composite)this.getMultiPageViewer().getContainer(), 0);
        SQLResultsListViewer viewer = new SQLResultsListViewer((Composite)viewForm, this);
        viewForm.setContent(viewer.getControl());
        this.createToolBar(viewForm, reSyntaxCheckAction);
        viewer.setInput(problems);
        viewer.addSelectionChangedListener(this);
        viewer.addDoubleClickListener(this);
        int pageIndex = this.getMultiPageViewer().addViewer((Viewer)viewer, viewForm);
        this.getMultiPageViewer().setPageText(pageIndex, tabTitle);
        if (!this.getHasValidMultiPageViewer()) {
            this.setHasValidMultiPageViewer(true);
            this.getPageBook().showPage((Control)this.getMultiPageViewer().getContainer());
        }
        return pageIndex;
    }

    private ToolBarManager createToolBar(ViewForm parent, IAction reSyntaxCheckAction) {
        return null;
    }

    @Override
    public String getDefaultText() {
        return UINlsStrings.SQLErrorsViewDefaultLabel;
    }

    @Override
    public String getTitle() {
        return UINlsStrings.SQLErrorsViewTitle;
    }

    @Override
    public String helpContext() {
        return IUIHelpConstants.SQL_RESULTS;
    }

    public void doubleClick(DoubleClickEvent event) {
        StructuredSelection ss = (StructuredSelection)event.getSelection();
        if (ss != null) {
            Object selection = ss.getFirstElement();
            if (!(selection instanceof IMarker)) {
                return;
            }
            IMarker marker = (IMarker)selection;
            if (marker.getResource() != null) {
                try {
                    IDE.openEditor((IWorkbenchPage)this.getSite().getPage(), (IMarker)marker, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        }
    }

    @Override
    public ISelection getSelection() {
        return this.getMultiPageViewer().getSelection();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        StructuredSelection ss = (StructuredSelection)event.getSelection();
        if (ss != null) {
            IEditorInput input;
            IWorkbenchPage page;
            IEditorPart editor;
            Object selection = ss.getFirstElement();
            if (!(selection instanceof IMarker)) {
                return;
            }
            IMarker marker = (IMarker)selection;
            if (marker.getResource() != null && (editor = (page = this.getSite().getPage()).getActiveEditor()) != null && (input = editor.getEditorInput()) instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)input).getFile();
                if (marker.getResource().equals((Object)file)) {
                    IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
                }
            }
        }
    }
}

