/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor;

import java.util.ResourceBundle;
import org.eclipse.edt.compiler.internal.core.builder.DefaultProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.Problem;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class ReportedProblem {
    int startOffset;
    int endOffset;
    int severity;
    int lineNumber = -1;
    int problemKind = -1;
    String message;
    String errorMsgCode;
    IDocument document;

    public ReportedProblem(IDocument document, String filePath, String errorMsg, Problem problem) {
        this.startOffset = problem.getStartOffset();
        this.endOffset = problem.getEndOffset();
        this.severity = this.translateSeverity(problem.getSeverity());
        this.errorMsgCode = errorMsg;
        this.problemKind = problem.getProblemKind();
        this.document = document;
        int lineNumber = this.getLineNumberOfOffset(this.startOffset);
        int problemKind = problem.getProblemKind();
        String[] inserts = problem.getInserts();
        this.message = problemKind != -1 ? this.getErrorMessageText(problemKind, this.startOffset, lineNumber, this.severity, DefaultProblemRequestor.getMessageFromBundle((int)problemKind, (String[])inserts, (ResourceBundle)problem.getResourceBundle())) : this.getErrorMessageText(problemKind, this.startOffset, lineNumber, this.severity, inserts[0]);
        this.lineNumber = lineNumber + 1;
    }

    private String getErrorMessageText(int problemKind, int startOffset, int lineNumber, int severity, String msgText) {
        StringBuffer result = new StringBuffer();
        result.append(this.getMessagePrefix(problemKind, startOffset, lineNumber, severity));
        result.append(" ");
        result.append(msgText);
        return result.toString();
    }

    private String getMessagePrefix(int problemKind, int startOffset, int lineNumber, int severity) {
        StringBuffer prefix = new StringBuffer();
        prefix.append("IWN.");
        prefix.append(this.errorMsgCode);
        if (problemKind != -1) {
            prefix.append(".");
            prefix.append(Integer.toString(problemKind));
        }
        if (2 == severity) {
            prefix.append(".e");
        } else if (1 == severity) {
            prefix.append(".w");
        } else if (severity == 0) {
            prefix.append(".i");
        }
        prefix.append(" ");
        prefix.append(Integer.toString(lineNumber + 1));
        prefix.append("/");
        int offsetOnLine = startOffset - this.getLineOffset(lineNumber);
        prefix.append(Integer.toString(offsetOnLine + 1));
        return prefix.toString();
    }

    private int getLineOffset(int lineNumber) {
        int offset = 0;
        try {
            offset = this.document.getLineOffset(lineNumber);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return offset;
    }

    private int getLineNumberOfOffset(int offset) {
        int line = 0;
        try {
            line = this.document.getLineOfOffset(offset);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return line;
    }

    private int translateSeverity(int severity) {
        switch (severity) {
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 0: {
                return 0;
            }
        }
        return 2;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getProblemKind() {
        return this.problemKind;
    }
}

