/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.deployment.ui.project.artifacts;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.deployment.ui.project.artifacts.ProjectArtifactTreeViewerContentProvider;
import org.eclipse.edt.ide.ui.internal.deployment.ui.project.artifacts.ProjectArtifactTreeViewerLabelProvider;
import org.eclipse.edt.ide.ui.internal.deployment.ui.project.artifacts.TreeNode;
import org.eclipse.edt.ide.ui.internal.deployment.ui.project.artifacts.TreeNodeFolder;
import org.eclipse.edt.ide.ui.internal.deployment.ui.project.artifacts.TreeNodeRoot;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class ProjectArtifactTreeViewer {
    private CheckboxTreeViewer viewer;
    private List treeNodeStateListeners = new ArrayList();

    public void addTreeNodeStateListener(ITreeNodeStateListener listener) {
        this.treeNodeStateListeners.add(listener);
    }

    public void removeTreeNodeStateListener(ITreeNodeStateListener listener) {
        this.treeNodeStateListeners.remove(listener);
    }

    public void createControl(Composite parent) {
        this.viewer = new CheckboxTreeViewer(parent, 2048){

            public void doUpdateItem(Item item, Object element) {
                super.doUpdateItem(item, element);
                ((TreeItem)item).setChecked(((TreeNode)element).isChecked());
                ((TreeItem)item).setGrayed(((TreeNode)element).isGrayed());
            }

            protected void preservingSelection(Runnable updateCode) {
                updateCode.run();
            }
        };
        this.viewer.setContentProvider((IContentProvider)new ProjectArtifactTreeViewerContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ProjectArtifactTreeViewerLabelProvider());
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(final CheckStateChangedEvent event) {
                final IWorkbench wb = PlatformUI.getWorkbench();
                IProgressService ps = wb.getProgressService();
                try {
                    ps.busyCursorWhile(new IRunnableWithProgress(){

                        public void run(final IProgressMonitor pm) {
                            wb.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    pm.beginTask("Progress Label", 23);
                                    TreeNode node = (TreeNode)event.getElement();
                                    boolean state = event.getChecked();
                                    node.setChecked(state);
                                    HashSet<TreeNode> changedNodes = new HashSet<TreeNode>(50);
                                    changedNodes.add(node);
                                    pm.worked(1);
                                    ProjectArtifactTreeViewer.this.walkDownTree(node, state, changedNodes);
                                    pm.worked(10);
                                    ProjectArtifactTreeViewer.this.walkUpTree(node, state, changedNodes);
                                    pm.worked(10);
                                    Iterator it = ProjectArtifactTreeViewer.this.treeNodeStateListeners.iterator();
                                    while (it.hasNext()) {
                                        ((ITreeNodeStateListener)it.next()).changed(changedNodes.toArray(new TreeNode[changedNodes.size()]));
                                    }
                                    pm.worked(2);
                                    pm.done();
                                }
                            });
                        }
                    });
                }
                catch (InvocationTargetException ioe) {
                    EDTUIPlugin.log(ioe);
                }
                catch (InterruptedException ie) {
                    EDTUIPlugin.log(ie);
                }
            }
        });
    }

    public void initializeTree(TreeNodeRoot root, List resourceOmissions) {
        this.buildTree(root, resourceOmissions);
        this.viewer.setInput((Object)root);
    }

    private void walkDownTree(TreeNode seed, boolean checked, Set changedNodes) {
        if (seed instanceof TreeNodeFolder) {
            if (!checked) {
                this.setChecked(seed, false, false, changedNodes);
            }
            for (TreeNode node : seed.getChildren()) {
                this.setChecked(node, checked, false, changedNodes);
                if (!(node instanceof TreeNodeFolder)) continue;
                this.walkDownTree(node, checked, changedNodes);
            }
        }
    }

    private void setChecked(TreeNode node, boolean checked, boolean gray, Set changedNodes) {
        if (node.isChecked != checked) {
            changedNodes.add(node);
        }
        node.setChecked(checked);
        node.setGrayed(gray);
        this.viewer.update((Object)node, null);
    }

    private void walkUpTree(TreeNode seed, boolean checked, Set changedNodes) {
        boolean isGray = seed.isGrayed();
        boolean isChecked = checked;
        TreeNode parent = seed.getParent();
        if (parent instanceof TreeNodeFolder) {
            boolean isParentGray = parent.isGrayed();
            boolean isParentChecked = parent.isChecked();
            if (isGray && isChecked) {
                if (!isParentGray || !isParentChecked) {
                    this.setChecked(parent, true, true, changedNodes);
                    this.walkUpTree(parent, isChecked, changedNodes);
                }
            } else if (!isGray && isChecked) {
                if (!isParentChecked) {
                    if (parent.getChildren().size() == 1) {
                        this.setChecked(parent, true, false, changedNodes);
                        this.walkUpTree(parent, true, changedNodes);
                    } else {
                        this.setChecked(parent, true, true, changedNodes);
                        this.walkUpTree(parent, true, changedNodes);
                    }
                } else {
                    this.checkParent(parent, changedNodes);
                    this.walkUpTree(parent, parent.isChecked(), changedNodes);
                }
            } else if (!isGray && !isChecked && isParentChecked) {
                if (!isParentGray) {
                    this.checkParent(parent, changedNodes);
                    this.walkUpTree(parent, parent.isChecked(), changedNodes);
                } else {
                    this.checkParent(parent, changedNodes);
                    this.walkUpTree(parent, parent.isChecked(), changedNodes);
                }
            }
        }
    }

    private void checkParent(TreeNode seed, Set changedNodes) {
        if (seed instanceof TreeNodeFolder) {
            boolean foundCheckedChild = false;
            boolean foundUncheckedChild = false;
            for (TreeNode child : seed.getChildren()) {
                if (child.isChecked()) {
                    foundCheckedChild = true;
                    if (!child.isGrayed()) continue;
                    foundUncheckedChild = true;
                    continue;
                }
                foundUncheckedChild = true;
            }
            if (!foundCheckedChild) {
                this.setChecked(seed, false, false, changedNodes);
            } else if (foundUncheckedChild) {
                this.setChecked(seed, true, true, changedNodes);
            } else {
                this.setChecked(seed, true, false, changedNodes);
            }
        }
    }

    public CheckboxTreeViewer getViewer() {
        return this.viewer;
    }

    public void buildTree(TreeNode node, List resourceOmissions) {
        for (TreeNode child : node.getChildren()) {
            this.checkAgainstOmissions(child, resourceOmissions);
            this.buildTree(child, resourceOmissions);
        }
        this.initializeFolderSelections(node);
    }

    private void checkAgainstOmissions(TreeNode node, List resourceOmissions) {
        node.setChecked(resourceOmissions == null || !resourceOmissions.contains(node.getResource().getFullPath().toString()) && node.getParent().isChecked());
    }

    private void initializeFolderSelections(TreeNode sourceNode) {
        for (TreeNode node : sourceNode.getChildren()) {
            if (!(node instanceof TreeNodeFolder)) continue;
            this.initializeFolderSelections(node);
        }
        if (sourceNode instanceof TreeNodeFolder) {
            boolean selected = false;
            boolean unselected = false;
            boolean grey = false;
            List children = sourceNode.getChildren();
            int size = children.size();
            if (size == 0) {
                selected = true;
            } else {
                int i = 0;
                while (!grey && i < size) {
                    TreeNode node = (TreeNode)children.get(i);
                    if (node.isGrayed()) {
                        grey = true;
                    } else if (node.isChecked()) {
                        selected = true;
                    } else {
                        unselected = true;
                    }
                    ++i;
                }
            }
            if (grey) {
                sourceNode.setGrayed(true);
                sourceNode.setChecked(true);
            } else if (selected) {
                if (unselected) {
                    sourceNode.setGrayed(true);
                    sourceNode.setChecked(true);
                } else {
                    sourceNode.setGrayed(false);
                    sourceNode.setChecked(true);
                }
            } else {
                sourceNode.setGrayed(false);
                sourceNode.setChecked(false);
            }
        }
    }

    public static interface ITreeNodeStateListener {
        public void changed(TreeNode[] var1);
    }
}

