/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.deployment.ui;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDBaseFormPage;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDRootHelper;
import org.eclipse.edt.ide.ui.internal.deployment.ui.SOAMessages;
import org.eclipse.edt.ide.ui.internal.deployment.ui.project.artifacts.ProjectArtifactTreeViewer;
import org.eclipse.edt.ide.ui.internal.deployment.ui.project.artifacts.TreeNode;
import org.eclipse.edt.ide.ui.internal.deployment.ui.project.artifacts.TreeNodeFile;
import org.eclipse.edt.ide.ui.internal.deployment.ui.project.artifacts.TreeNodeFolder;
import org.eclipse.edt.ide.ui.internal.deployment.ui.project.artifacts.TreeNodeRoot;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class EGLDDResourcesFormPage
extends EGLDDBaseFormPage {
    private ProjectArtifactTreeViewer fArtifactTreeViewer;
    private TreeNodeRoot fTreeRoot;
    private Button fRefreshButton;

    public EGLDDResourcesFormPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        form.setText(SOAMessages.ArtifactsTitle);
        managedForm.setInput((Object)this.getModelRoot());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        form.getBody().setLayout((Layout)layout);
        FormToolkit toolkit = managedForm.getToolkit();
        Composite client = EGLDDResourcesFormPage.createNonExpandableSection(form, toolkit, SOAMessages.ArtifactsTitle, SOAMessages.ArtifactsDetailPageDesc, 2);
        this.createAdditionalArtifactsSection(toolkit, client);
        this.init();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form.getBody(), this.getHelpID());
    }

    private void init() {
        this.fTreeRoot.children = null;
        this.initializeArtifactTree();
        this.getManagedForm().reflow(true);
    }

    private void createAdditionalArtifactsSection(FormToolkit toolkit, Composite parent) {
        int layoutColumn;
        Composite fArtifactSection = toolkit.createComposite(parent, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        fArtifactSection.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.verticalSpan = 2;
        fArtifactSection.setLayoutData((Object)gd);
        this.fArtifactTreeViewer = new ProjectArtifactTreeViewer();
        this.fArtifactTreeViewer.createControl(fArtifactSection);
        gd = new GridData(768);
        gd.horizontalSpan = layoutColumn = 1;
        gd.heightHint = 200;
        gd.widthHint = 60;
        this.fArtifactTreeViewer.getViewer().getTree().setLayoutData((Object)gd);
        this.fArtifactTreeViewer.addTreeNodeStateListener(new ProjectArtifactTreeViewer.ITreeNodeStateListener(){

            @Override
            public void changed(TreeNode[] nodes) {
                LinkedHashSet<TreeNodeFolder> changedFolders = new LinkedHashSet<TreeNodeFolder>(nodes.length);
                int i = 0;
                while (i < nodes.length) {
                    if (nodes[i] instanceof TreeNodeFile && nodes[i].isDeployable()) {
                        if (((TreeNodeFile)nodes[i]).getParent() instanceof TreeNodeFolder) {
                            changedFolders.add((TreeNodeFolder)((TreeNodeFile)nodes[i]).getParent());
                        }
                    } else if (nodes[i] instanceof TreeNodeFolder) {
                        changedFolders.add((TreeNodeFolder)nodes[i]);
                    }
                    ++i;
                }
                LinkedHashSet omissionsToAdd = new LinkedHashSet(nodes.length);
                LinkedHashSet omissionsToRemove = new LinkedHashSet(nodes.length);
                ArrayList processedNodes = new ArrayList();
                for (TreeNodeFolder folder : changedFolders) {
                    EGLDDResourcesFormPage.this.assembleOmissionList(folder, omissionsToAdd, omissionsToRemove, processedNodes);
                }
                EGLDDRootHelper.processResourceOmissionChanges(EGLDDResourcesFormPage.this.getModelRoot(), new ArrayList(omissionsToAdd), new ArrayList(omissionsToRemove));
            }
        });
        this.fTreeRoot = new TreeNodeRoot(null, (IResource)this.getEditorProject());
        Composite buttonComposite = toolkit.createComposite(fArtifactSection);
        layoutColumn = 2;
        layout = new GridLayout(layoutColumn, false);
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        gd = new GridData(1040);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)gd);
        this.fRefreshButton = toolkit.createButton(buttonComposite, SOAMessages.Refresh, 8);
        this.fRefreshButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EGLDDResourcesFormPage.this.init();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void assembleOmissionList(TreeNodeFolder folder, Set<String> omissionsToAdd, Set<String> omissionsToRemove, List<TreeNodeFolder> processedFolders) {
        if (!processedFolders.contains(folder)) {
            processedFolders.add(folder);
            boolean folderIsChecked = folder instanceof TreeNodeRoot || folder.isChecked();
            for (Object node2 : folder.getChildren()) {
                if (!(node2 instanceof TreeNode)) continue;
                if (node2 instanceof TreeNodeFolder) {
                    this.assembleOmissionList((TreeNodeFolder)node2, omissionsToAdd, omissionsToRemove, processedFolders);
                    continue;
                }
                if (folderIsChecked) {
                    if (((TreeNode)node2).isChecked()) {
                        omissionsToRemove.add(((TreeNode)node2).getResource().getFullPath().toString());
                        continue;
                    }
                    omissionsToAdd.add(((TreeNode)node2).getResource().getFullPath().toString());
                    continue;
                }
                omissionsToRemove.add(((TreeNode)node2).getResource().getFullPath().toString());
            }
            if (!(folder instanceof TreeNodeRoot)) {
                if (folder.isChecked()) {
                    omissionsToRemove.add(folder.getResource().getFullPath().toString());
                } else if (folder.getParent() instanceof TreeNodeRoot || folder.getParent().isChecked()) {
                    omissionsToAdd.add(folder.getResource().getFullPath().toString());
                } else {
                    omissionsToRemove.add(folder.getResource().getFullPath().toString());
                }
            }
        }
    }

    private void initializeArtifactTree() {
        List omissions = EGLDDRootHelper.getResourceOmissionsAsStrings(this.getModelRoot());
        this.fArtifactTreeViewer.initializeTree(this.fTreeRoot, omissions);
    }

    protected void createSpacer(FormToolkit toolkit, Composite parent, int span) {
        Label spacer = toolkit.createLabel(parent, "");
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        spacer.setLayoutData((Object)gd);
    }

    public void clear() {
    }

    public void setFocus() {
        if (this.fArtifactTreeViewer != null && this.fArtifactTreeViewer.getViewer() != null) {
            this.init();
            this.fArtifactTreeViewer.getViewer().getTree().setFocus();
        }
    }

    @Override
    protected String getHelpID() {
        return IUIHelpConstants.EGLDD_EDITOR_RESOURCESPAGE;
    }
}

