/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.deployment.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.utils.BinaryReadOnlyFile;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.EGLUIStatus;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDeploymentDescriptorEditor;
import org.eclipse.edt.ide.ui.internal.deployment.ui.SOAMessages;
import org.eclipse.edt.ide.ui.internal.editor.BinaryEditorInput;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.part.FileEditorInput;

public abstract class EGLDDBaseDetailPage
implements IDetailsPage {
    public static Color READONLY_BACKGROUNDCOLOR = Display.getCurrent().getSystemColor(22);
    protected IManagedForm mform;
    protected int nColumnSpan = 3;

    public static void try2OpenPartInEGLEditor(EGLDeploymentDescriptorEditor serviceBindingEditor, String fullyqualifiedPartName) {
        EGLDDBaseDetailPage.try2OpenPartInEGLEditor(serviceBindingEditor, fullyqualifiedPartName, "org.eclipse.edt.ide.ui.EGLEditor");
    }

    public static void try2OpenPartInEGLEditor(EGLDeploymentDescriptorEditor serviceBindingEditor, String fullyqualifiedPartName, String editorId) {
        IProject proj = serviceBindingEditor.getProject();
        IEGLProject eglProj = EGLCore.create((IProject)proj);
        IFile file = org.eclipse.edt.ide.core.internal.utils.Util.findPartFile((String)fullyqualifiedPartName, (IEGLProject)eglProj);
        if (file != null && file.exists()) {
            if (Util.isEGLFileName((String)file.getName())) {
                EGLDDBaseDetailPage.openEGLFile(file, editorId);
            } else if (Util.isEGLARFileName((String)file.getName())) {
                EGLDDBaseDetailPage.openClassFile(proj, file.getFullPath().toString(), fullyqualifiedPartName, "org.eclipse.edt.ide.ui.BinaryFileEditor");
            }
        } else if (file == null) {
            String eglarFilePath = org.eclipse.edt.ide.core.internal.utils.Util.findPartFilePath((String)fullyqualifiedPartName, (IEGLProject)eglProj);
            String fileName = eglarFilePath;
            if (fileName.endsWith(File.separator) || fileName.endsWith("/")) {
                fileName = fileName.substring(0, fileName.length() - 1);
            }
            if (Util.isEGLARFileName((String)fileName)) {
                EGLDDBaseDetailPage.openClassFile(proj, eglarFilePath, fullyqualifiedPartName, "org.eclipse.edt.ide.ui.BinaryFileEditor");
            }
        } else {
            IStatus status = EGLUIStatus.createError(-1, SOAMessages.bind((String)SOAMessages.ModuleBaseDetailPageFileNotExist, (Object)fullyqualifiedPartName), null);
            ErrorDialog.openError((Shell)serviceBindingEditor.getSite().getShell(), null, null, (IStatus)status);
        }
    }

    public static void openClassFile(final IProject proj, final String eglarFilePath, final String irFullQualifiedFile, final String editorId) {
        final IWorkbenchWindow ww = EDTUIPlugin.getActiveWorkbenchWindow();
        Display d = ww.getShell().getDisplay();
        d.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    BinaryReadOnlyFile storage = null;
                    storage = proj == null ? new BinaryReadOnlyFile(eglarFilePath, irFullQualifiedFile, "") : new BinaryReadOnlyFile(eglarFilePath, irFullQualifiedFile, "", proj, true);
                    BinaryEditorInput input = new BinaryEditorInput(storage);
                    ww.getActivePage().openEditor((IEditorInput)input, editorId);
                }
                catch (PartInitException e) {
                    EDTUIPlugin.log(e);
                }
            }
        });
    }

    public static void openEGLFile(final IFile file, final String editorId) {
        final IWorkbenchWindow ww = EDTUIPlugin.getActiveWorkbenchWindow();
        Display d = ww.getShell().getDisplay();
        d.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    ww.getActivePage().openEditor((IEditorInput)new FileEditorInput(file), editorId);
                }
                catch (PartInitException e) {
                    EDTUIPlugin.log(e);
                }
            }
        });
    }

    public void createContents(Composite parent) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 5;
        layout.leftMargin = 5;
        layout.rightMargin = 5;
        layout.bottomMargin = 2;
        parent.setLayout((Layout)layout);
        FormToolkit toolkit = this.mform.getToolkit();
        this.createTopNonExpandableSection(parent, toolkit);
    }

    protected Composite createDetailSection(Composite parent, FormToolkit toolkit, int sectionStyle, int columnSpan) {
        return this.createSection(parent, toolkit, "", "", sectionStyle, columnSpan);
    }

    protected void createTopNonExpandableSection(Composite parent, FormToolkit toolkit) {
        Composite client = this.createDetailSection(parent, toolkit, 640, this.nColumnSpan);
        this.createControlsInTopSection(toolkit, client);
    }

    protected abstract void createControlsInTopSection(FormToolkit var1, Composite var2);

    protected Composite createSection(Composite parent, FormToolkit toolkit, String title, String desc, int SectionStyle, int numColumns) {
        Section section = toolkit.createSection(parent, SectionStyle);
        section.marginWidth = 10;
        section.setText(title);
        section.setDescription(desc);
        TableWrapData td = new TableWrapData(128, 16);
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite client = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.numColumns = numColumns;
        client.setLayout((Layout)layout);
        section.setClient((Control)client);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                EGLDDBaseDetailPage.this.mform.getForm().reflow(false);
            }
        });
        return client;
    }

    protected void createSpacer(FormToolkit toolkit, Composite parent, int span) {
        Label spacer = toolkit.createLabel(parent, "");
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        spacer.setLayoutData((Object)gd);
    }

    protected FormPage getContainerFormPage() {
        return (FormPage)this.mform.getContainer();
    }

    protected EGLDeploymentDescriptorEditor getEGLServiceBindingEditor() {
        return (EGLDeploymentDescriptorEditor)this.getContainerFormPage().getEditor();
    }

    protected IProject getEditorProject() {
        return this.getEGLServiceBindingEditor().getProject();
    }

    public void initialize(IManagedForm form) {
        this.mform = form;
    }

    public static class StringInput
    implements IStorageEditorInput {
        private IStorage storage;

        public StringInput(IStorage storage) {
            this.storage = storage;
        }

        public boolean exists() {
            return true;
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public String getName() {
            return this.storage.getName();
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public IStorage getStorage() {
            return this.storage;
        }

        public String getToolTipText() {
            return "file: " + this.storage.getName();
        }

        public Object getAdapter(Class adapter) {
            return null;
        }
    }

    public static class StringStorage
    implements IStorage {
        private String pathString;

        public StringStorage(String input) {
            this.pathString = input;
        }

        public InputStream getContents() throws CoreException {
            FileInputStream fs = null;
            try {
                fs = new FileInputStream(this.pathString);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            return fs;
        }

        public IPath getFullPath() {
            return new Path(this.pathString);
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public String getName() {
            return this.getFullPath().lastSegment();
        }

        public boolean isReadOnly() {
            return true;
        }
    }
}

