/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.AnnotationExpression;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.Constructor;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.EnumerationField;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.NewExpression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.ide.core.internal.errors.ParseStack;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLPartSearchAnnotationProposalHandler;
import org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion.EGLAbstractReferenceCompletion;
import org.eclipse.edt.mof.egl.AnnotationType;
import org.eclipse.jface.text.ITextViewer;

public class EGLSettingsBlockAnnotationCompletion
extends EGLAbstractReferenceCompletion {
    @Override
    protected void precompileContexts() {
        this.addContext("package a; handler a {");
        this.addContext("package a; handler a {@a{},");
        this.addContext("package a; handler a {a=a,");
        this.addContext("package a; handler a a atype{");
        this.addContext("package a; handler a function a(){");
        this.addContext("package a; handler a function a() a{");
    }

    @Override
    protected List returnCompletionProposals(ParseStack parseStack, final String prefix, final ITextViewer viewer, final int documentOffset) {
        final ArrayList proposals = new ArrayList();
        this.getBoundASTNode(viewer, documentOffset, new String[]{"", "a};", "a", "};", "}};"}, new EGLAbstractReferenceCompletion.CompletedNodeVerifier(){

            @Override
            public boolean nodeIsValid(Node astNode) {
                return astNode instanceof SettingsBlock;
            }
        }, new EGLAbstractReferenceCompletion.IBoundNodeProcessor(){

            @Override
            public void processBoundNode(Node boundNode) {
                if (this.shouldShowAnnotations(boundNode)) {
                    proposals.addAll(new EGLPartSearchAnnotationProposalHandler(viewer, documentOffset, prefix, EGLSettingsBlockAnnotationCompletion.this.editor, EGLSettingsBlockAnnotationCompletion.this.addPrefix(), true, this.getAnnotationsAlreadySpecified(boundNode), boundNode).getProposals(8, "", new String[]{"annotation", "eglx.lang.Annotation"}));
                }
            }

            private List<AnnotationType> getAnnotationsAlreadySpecified(Node node) {
                final ArrayList<AnnotationType> list = new ArrayList<AnnotationType>();
                if (node instanceof SettingsBlock) {
                    node.accept((IASTVisitor)new DefaultASTVisitor(){

                        public boolean visit(SettingsBlock settingsBlock) {
                            return true;
                        }

                        public boolean visit(SetValuesExpression setValuesExpression) {
                            AnnotationExpression annExp;
                            if (setValuesExpression.getExpression() instanceof AnnotationExpression && (annExp = (AnnotationExpression)setValuesExpression.getExpression()).resolveAnnotation() != null) {
                                list.add((AnnotationType)annExp.resolveAnnotation().getEClass());
                            }
                            return false;
                        }
                    });
                }
                return list;
            }

            private boolean shouldShowAnnotations(Node node) {
                if ((node = node.getParent()) == null) {
                    return false;
                }
                if (node instanceof NewExpression) {
                    return false;
                }
                if (node instanceof SetValuesExpression) {
                    return false;
                }
                if (node instanceof StructureItem) {
                    return true;
                }
                if (node instanceof ClassDataDeclaration) {
                    return true;
                }
                if (node instanceof FunctionDataDeclaration) {
                    return true;
                }
                if (node instanceof Part) {
                    return true;
                }
                if (node instanceof EnumerationField) {
                    return true;
                }
                if (node instanceof NestedFunction) {
                    return true;
                }
                if (node instanceof Constructor) {
                    return true;
                }
                return this.shouldShowAnnotations(node);
            }
        });
        return proposals;
    }

    protected boolean addPrefix() {
        return true;
    }
}

