/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal;

import java.util.Arrays;
import org.eclipse.edt.ide.ui.internal.CodeFormatterUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.osgi.util.TextProcessor;

public class Strings {
    private static final boolean USE_TEXT_PROCESSOR;

    static {
        String testString = "args : String[]";
        USE_TEXT_PROCESSOR = testString != TextProcessor.process((String)testString);
    }

    private Strings() {
    }

    private static boolean isIndentChar(char ch) {
        return Character.isWhitespace(ch) && !Strings.isLineDelimiterChar(ch);
    }

    public static boolean isLowerCase(char ch) {
        return Character.toLowerCase(ch) == ch;
    }

    private static boolean isLineDelimiterChar(char ch) {
        return ch == '\n' || ch == '\r';
    }

    public static String[] convertIntoLines(String input) {
        try {
            DefaultLineTracker tracker = new DefaultLineTracker();
            tracker.set(input);
            int size = tracker.getNumberOfLines();
            String[] result = new String[size];
            int i = 0;
            while (i < size) {
                IRegion region = tracker.getLineInformation(i);
                int offset = region.getOffset();
                result[i] = input.substring(offset, offset + region.getLength());
                ++i;
            }
            return result;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public static boolean containsOnlyWhitespaces(String s) {
        int size = s.length();
        int i = 0;
        while (i < size) {
            if (!Character.isWhitespace(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String trimLeadingTabsAndSpaces(String line) {
        int size;
        int start = size = line.length();
        int i = 0;
        while (i < size) {
            char c = line.charAt(i);
            if (!Strings.isIndentChar(c)) {
                start = i;
                break;
            }
            ++i;
        }
        if (start == 0) {
            return line;
        }
        if (start == size) {
            return "";
        }
        return line.substring(start);
    }

    public static int computeIndentUnits(String line, int tabWidth, int indentWidth) {
        if (indentWidth == 0) {
            return -1;
        }
        int visualLength = Strings.measureIndentLength(line, tabWidth);
        return visualLength / indentWidth;
    }

    private static int measureIndentLength(CharSequence line, int tabSize) {
        int length = 0;
        int max = line.length();
        int i = 0;
        while (i < max) {
            char ch = line.charAt(i);
            if (ch == '\t') {
                int reminder = length % tabSize;
                length += tabSize - reminder;
            } else if (Strings.isIndentChar(ch)) {
                ++length;
            } else {
                return length;
            }
            ++i;
        }
        return length;
    }

    private static String trimIndent(String line, int indentsToRemove, int tabWidth, int indentWidth) {
        if (line == null || indentsToRemove <= 0) {
            return line;
        }
        int spaceEquivalentsToRemove = indentsToRemove * indentWidth;
        int start = 0;
        int spaceEquivalents = 0;
        int size = line.length();
        String prefix = null;
        int i = 0;
        while (i < size) {
            char c = line.charAt(i);
            if (c == '\t') {
                int remainder = spaceEquivalents % tabWidth;
                spaceEquivalents += tabWidth - remainder;
            } else if (Strings.isIndentChar(c)) {
                ++spaceEquivalents;
            } else {
                start = i;
                break;
            }
            if (spaceEquivalents == spaceEquivalentsToRemove) {
                start = i + 1;
                break;
            }
            if (spaceEquivalents > spaceEquivalentsToRemove) {
                start = i + 1;
                char[] missing = new char[spaceEquivalents - spaceEquivalentsToRemove];
                Arrays.fill(missing, ' ');
                prefix = new String(missing);
                break;
            }
            ++i;
        }
        String trimmed = start == size ? "" : line.substring(start);
        if (prefix == null) {
            return trimmed;
        }
        return String.valueOf(prefix) + trimmed;
    }

    public static void trimIndentation(String[] lines, IJavaProject project, boolean considerFirstLine) {
        Strings.trimIndentation(lines, CodeFormatterUtil.getTabWidth(project), CodeFormatterUtil.getIndentWidth(project), considerFirstLine);
    }

    private static void trimIndentation(String[] lines, int tabWidth, int indentWidth, boolean considerFirstLine) {
        String[] toDo = new String[lines.length];
        int minIndent = Integer.MAX_VALUE;
        int i = considerFirstLine ? 0 : 1;
        while (i < lines.length) {
            String line = lines[i];
            if (!Strings.containsOnlyWhitespaces(line)) {
                toDo[i] = line;
                int indent = Strings.computeIndentUnits(line, tabWidth, indentWidth);
                if (indent < minIndent) {
                    minIndent = indent;
                }
            }
            ++i;
        }
        if (minIndent > 0) {
            i = considerFirstLine ? 0 : 1;
            while (i < toDo.length) {
                String line;
                int indent;
                String s = toDo[i];
                lines[i] = s != null ? Strings.trimIndent(s, minIndent, tabWidth, indentWidth) : ((indent = Strings.computeIndentUnits(line = lines[i], tabWidth, indentWidth)) > minIndent ? Strings.trimIndent(line, minIndent, tabWidth, indentWidth) : Strings.trimLeadingTabsAndSpaces(line));
                ++i;
            }
        }
    }

    public static String concatenate(String[] lines, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < lines.length) {
            if (i > 0) {
                buffer.append(delimiter);
            }
            buffer.append(lines[i]);
            ++i;
        }
        return buffer.toString();
    }

    public static String removeMnemonicIndicator(String string) {
        return LegacyActionTools.removeMnemonics((String)string);
    }

    public static StyledString markLTR(StyledString styledString) {
        if (!USE_TEXT_PROCESSOR) {
            return styledString;
        }
        String string = TextProcessor.process((String)styledString.getString());
        return new StyledString(string);
    }

    public static StyledString markLTR(StyledString styledString, String additionalDelimiters) {
        if (!USE_TEXT_PROCESSOR) {
            return styledString;
        }
        String string = TextProcessor.process((String)styledString.getString(), (String)(String.valueOf(TextProcessor.getDefaultDelimiters()) + additionalDelimiters));
        return new StyledString(string);
    }

    public static String markLTR(String string) {
        if (!USE_TEXT_PROCESSOR) {
            return string;
        }
        return TextProcessor.process((String)string);
    }

    public static String markLTR(String string, String additionalDelimiters) {
        if (!USE_TEXT_PROCESSOR) {
            return string;
        }
        return TextProcessor.process((String)string, (String)(String.valueOf(TextProcessor.getDefaultDelimiters()) + additionalDelimiters));
    }
}

