/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.editor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.ITextContentDescriber;

public class CommonFileDescriber
implements ITextContentDescriber {
    private Pattern handlerPattern = Pattern.compile("\\bHANDLER\\b\\s\\s*.*\\s*\\s\\bTYPE\\b\\s\\s*\\bRUIHANDLER", 2);
    private Pattern widgetPattern = Pattern.compile("\\bHANDLER\\b\\s\\s*.*\\s*\\s\\bTYPE\\b\\s\\s*\\bRUIWIDGET", 2);

    public int describe(InputStream contents, IContentDescription description) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(contents, "UTF-8"));
        while ((line = reader.readLine()) != null) {
            Matcher handlerMatcher = this.handlerPattern.matcher(line);
            Matcher widgetMatcher = this.widgetPattern.matcher(line);
            if (!handlerMatcher.find() && !widgetMatcher.find()) continue;
            return 0;
        }
        return 2;
    }

    public QualifiedName[] getSupportedOptions() {
        return new QualifiedName[0];
    }

    public int describe(Reader contents, IContentDescription description) throws IOException {
        return 0;
    }
}

