/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.resources.egldd;

import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.edt.javart.resources.egldd.Binding;
import org.eclipse.edt.javart.resources.egldd.Parameter;
import org.eclipse.edt.javart.resources.egldd.RuntimeDeploymentDesc;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class RuntimeDeploymentDescParser
extends DefaultHandler {
    protected RuntimeDeploymentDesc desc;
    private Binding currentBinding;
    private StringBuffer handledCharacters;

    public RuntimeDeploymentDesc parse(RuntimeDeploymentDesc desc, String path) throws Exception {
        this.desc = desc;
        return this.parse(new InputSource(new FileReader(path)));
    }

    public RuntimeDeploymentDesc parse(RuntimeDeploymentDesc desc, InputStream is) throws Exception {
        this.desc = desc;
        return this.parse(new InputSource(is));
    }

    protected RuntimeDeploymentDesc parse(InputSource source) throws IOException, SAXException {
        XMLReader xr = XMLReaderFactory.createXMLReader();
        xr.setContentHandler(this);
        xr.setErrorHandler(this);
        xr.parse(source);
        return this.desc;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (localName.equals("binding")) {
            this.currentBinding = new Binding(attributes.getValue("name"), attributes.getValue("type"), attributes.getValue("uri"), attributes.getValue("useURI"));
        } else if (localName.equals("include")) {
            String location = attributes.getValue("location");
            if (location != null && location.trim().length() > 0) {
                this.desc.addInclude(location);
            }
        } else if (localName.equals("parameter")) {
            Parameter parameter = new Parameter(attributes.getValue("name"), attributes.getValue("type"), attributes.getValue("value"));
            this.addParameter(parameter);
        }
    }

    protected void addParameter(Parameter param) {
        if (this.currentBinding != null) {
            this.currentBinding.addParameter(param);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (localName.equals("binding")) {
            this.desc.addBinding(this.currentBinding);
            this.currentBinding = null;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.handledCharacters != null) {
            int idx = 0;
            while (idx < length) {
                this.handledCharacters.append(ch[start + idx]);
                ++idx;
            }
        } else {
            super.characters(ch, start, length);
        }
    }
}

