/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.javart.json.ArrayNode;
import org.eclipse.edt.javart.json.BooleanNode;
import org.eclipse.edt.javart.json.DecimalNode;
import org.eclipse.edt.javart.json.FloatingPointNode;
import org.eclipse.edt.javart.json.IntegerNode;
import org.eclipse.edt.javart.json.JavaCharStream;
import org.eclipse.edt.javart.json.JsonParserConstants;
import org.eclipse.edt.javart.json.JsonParserTokenManager;
import org.eclipse.edt.javart.json.NameValuePairNode;
import org.eclipse.edt.javart.json.NullNode;
import org.eclipse.edt.javart.json.ObjectNode;
import org.eclipse.edt.javart.json.ParseException;
import org.eclipse.edt.javart.json.StringNode;
import org.eclipse.edt.javart.json.Token;
import org.eclipse.edt.javart.json.ValueNode;

public class JsonParser
implements JsonParserConstants {
    public JsonParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[5];
    private static int[] jj_la1_0;
    private List jj_expentries = new ArrayList();
    private int[] jj_expentry;
    private int jj_kind = -1;

    static {
        JsonParser.jj_la1_init_0();
    }

    public static void main(String[] args) throws ParseException {
        JsonParser parser = new JsonParser(System.in);
        parser.ObjectParse();
    }

    public static ValueNode parseValue(String parseString) throws ParseException {
        StringReader reader = new StringReader(parseString);
        JsonParser parser = new JsonParser(reader);
        return parser.valueParse(reader);
    }

    public final ValueNode valueParse(StringReader reader) throws ParseException {
        ValueNode node;
        this.token = this.token.next = this.token_source.getNextToken();
        if (this.token.kind == 14) {
            node = this.Array();
        } else {
            try {
                reader.reset();
            }
            catch (IOException iOException) {}
            this.ReInit(reader);
            node = this.Object();
        }
        return node;
    }

    public static ObjectNode parse(String parseString) throws ParseException {
        StringReader reader = new StringReader(parseString);
        JsonParser parser = new JsonParser(reader);
        return parser.ObjectParse();
    }

    public static ObjectNode parse(InputStream stream) throws ParseException {
        JsonParser parser = new JsonParser(stream);
        return parser.ObjectParse();
    }

    public final ObjectNode ObjectParse() throws ParseException {
        ObjectNode node = this.Object();
        return node;
    }

    public final ObjectNode Object() throws ParseException {
        ObjectNode obj = new ObjectNode();
        this.jj_consume_token(10);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                NameValuePairNode pair = this.Pair();
                obj.addPair(pair);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 11: {
                            break;
                        }
                        default: {
                            this.jj_la1[0] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(11);
                    pair = this.Pair();
                    obj.addPair(pair);
                }
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        this.jj_consume_token(12);
        return obj;
    }

    public final NameValuePairNode Pair() throws ParseException {
        StringNode string = this.String();
        this.jj_consume_token(13);
        ValueNode value = this.Value();
        return new NameValuePairNode(string, value);
    }

    public final StringNode String() throws ParseException {
        Token t = this.jj_consume_token(6);
        String str = t.image;
        return new StringNode(str.substring(1, str.length() - 1), true);
    }

    public final ValueNode Value() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                StringNode value = this.String();
                return value;
            }
            case 5: {
                Token t = this.jj_consume_token(5);
                String str = t.image;
                if (str.indexOf("e") > 0 || str.indexOf("E") > 0) {
                    return new FloatingPointNode(str);
                }
                if (str.indexOf(".") > 0) {
                    return new DecimalNode(str);
                }
                return new IntegerNode(str);
            }
            case 10: {
                ObjectNode value = this.Object();
                return value;
            }
            case 14: {
                this.jj_consume_token(14);
                ArrayNode value = this.Array();
                this.jj_consume_token(15);
                return value;
            }
            case 7: {
                Token t = this.jj_consume_token(7);
                return BooleanNode.TRUE;
            }
            case 8: {
                Token t = this.jj_consume_token(8);
                return BooleanNode.FALSE;
            }
            case 9: {
                Token t = this.jj_consume_token(9);
                return NullNode.NULL;
            }
        }
        this.jj_la1[2] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ArrayNode Array() throws ParseException {
        ArrayNode array = new ArrayNode();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: {
                ValueNode value = this.Value();
                array.addValue(value);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 11: {
                            break;
                        }
                        default: {
                            this.jj_la1[3] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(11);
                    value = this.Value();
                    array.addValue(value);
                }
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        return array;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{2048, 64, 18400, 2048, 18400};
    }

    public JsonParser(InputStream stream) {
        this(stream, null);
    }

    public JsonParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new JsonParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 5) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 5) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public JsonParser(Reader stream) {
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new JsonParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 5) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 5) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public JsonParser(JsonParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 5) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(JsonParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 5) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[16];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        int i = 0;
        while (i < 5) {
            if (this.jj_la1[i] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((jj_la1_0[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 16) {
            if (la1tokens[i]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i;
                this.jj_expentries.add(this.jj_expentry);
            }
            ++i;
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i2 = 0;
        while (i2 < this.jj_expentries.size()) {
            exptokseq[i2] = (int[])this.jj_expentries.get(i2);
            ++i2;
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }
}

