/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.core.java;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;

public class SMAPFileCache {
    private final Map<String, String> classNameToSMAP = new HashMap<String, String>();
    private final Map<String, String> workspacePathToClassName = new HashMap<String, String>();

    public void addEntry(String className, String smap, String workspacePath) {
        this.classNameToSMAP.put(className, smap);
        if (workspacePath != null && workspacePath.length() > 0 && ResourcesPlugin.getWorkspace().getRoot().findMember(workspacePath) != null) {
            this.workspacePathToClassName.put(workspacePath, className);
        }
    }

    public String getClassName(String workspacePath) {
        return this.workspacePathToClassName.get(workspacePath);
    }

    public String getSMAP(String className) {
        return this.classNameToSMAP.get(className);
    }

    public boolean containsSMAP(String className) {
        return this.classNameToSMAP.containsKey(className);
    }

    public String removeEntry(String workspacePath, String className) {
        if (workspacePath != null) {
            String removed = this.workspacePathToClassName.remove(workspacePath);
            if (className == null || className.length() == 0) {
                className = removed;
            }
        }
        if (className != null && className.length() > 0) {
            return this.classNameToSMAP.remove(className);
        }
        return null;
    }

    public void clear() {
        this.workspacePathToClassName.clear();
        this.classNameToSMAP.clear();
    }
}

