/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.utils;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.internal.PartWrapper;
import org.eclipse.edt.ide.core.Logger;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;
import org.osgi.service.prefs.BackingStoreException;

public class DefaultDeploymentDescriptorUtility {
    public static PartWrapper getDefaultDeploymentDescriptor(IResource resource) {
        PartWrapper partWrapper = null;
        String partPath = ProjectSettingsUtility.getDefaultDeploymentDescriptor(resource);
        String partName = "";
        if (partPath != null && partPath.length() > 0) {
            partName = new Path(partPath).removeFileExtension().lastSegment();
        }
        partWrapper = new PartWrapper();
        partWrapper.setPartPath(partPath);
        partWrapper.setPartName(partName);
        return partWrapper;
    }

    public static void setDefaultDeploymentDescriptor(IResource resource, PartWrapper defaultDD) {
        try {
            String pathValue = null;
            if (defaultDD != null) {
                pathValue = defaultDD.getPartPath();
            }
            ProjectSettingsUtility.setDefaultDeploymentDescriptor(resource.getProject(), pathValue);
        }
        catch (BackingStoreException e) {
            Logger.log(DefaultDeploymentDescriptorUtility.class, "DefaultDeploymentDescriptorUtility.setDefaultDeploymentDescriptor() - BackingStoreException", e);
        }
    }
}

