/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.utils;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.ide.core.internal.model.EGLModel;

public class AbsolutePathUtility {
    public static String getAbsolutePathString(String pathString) {
        return AbsolutePathUtility.getAbsolutePathString((IPath)new Path(pathString));
    }

    public static String getAbsolutePathString(IPath path) {
        Object obj = EGLModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), path, true);
        if (obj instanceof IResource) {
            IResource resource = (IResource)obj;
            URI location = resource.getLocationURI();
            if (location == null) {
                return "";
            }
            try {
                File localFile = AbsolutePathUtility.toLocalFile(location);
                return localFile.getPath();
            }
            catch (CoreException coreException) {
                return "";
            }
        }
        if (obj instanceof File) {
            try {
                return ((File)obj).getCanonicalPath();
            }
            catch (IOException iOException) {}
        }
        return path.toOSString();
    }

    private static File toLocalFile(URI uri) throws CoreException {
        IFileStore fileStore = EFS.getStore((URI)uri);
        File localFile = fileStore.toLocalFile(0, null);
        if (localFile == null) {
            localFile = fileStore.toLocalFile(4096, null);
        }
        return localFile;
    }
}

