/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.search.matching;

import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.AnnotationExpression;
import org.eclipse.edt.compiler.core.ast.AsExpression;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.CallStatement;
import org.eclipse.edt.compiler.core.ast.Class;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Delegate;
import org.eclipse.edt.compiler.core.ast.Enumeration;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.ExternalType;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.FunctionInvocation;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Interface;
import org.eclipse.edt.compiler.core.ast.IsAExpression;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NameType;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.NewExpression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.ReturnsDeclaration;
import org.eclipse.edt.compiler.core.ast.Service;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.core.ast.UseStatement;
import org.eclipse.edt.ide.core.internal.search.matching.MatchingNodeSet;
import org.eclipse.edt.mof.egl.AnnotationType;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.FunctionPart;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Record;
import org.eclipse.edt.mof.egl.StructuredRecord;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class MatchVisitor
extends AbstractASTExpressionVisitor {
    public MatchingNodeSet matchSet;
    private org.eclipse.edt.mof.egl.Part binding;

    public boolean visit(Enumeration enumeration) {
        this.visitPart((Part)enumeration);
        return true;
    }

    public boolean visit(Delegate delegate) {
        this.visitPart((Part)delegate);
        return true;
    }

    public boolean visit(ExternalType externalType) {
        this.visitPart((Part)externalType);
        Iterator iter = externalType.getExtendedTypes().iterator();
        while (iter.hasNext()) {
            this.matchName((Name)iter.next());
        }
        return true;
    }

    public boolean visit(SettingsBlock settingsBlock) {
        this.handlePropertyBlock(settingsBlock);
        return false;
    }

    private void handleProperty(Node decl) {
        decl.accept((IASTVisitor)new DefaultASTVisitor(){

            public boolean visit(AnnotationExpression annotationExpression) {
                MatchVisitor.this.matchName(annotationExpression.getName());
                return false;
            }

            public boolean visit(SetValuesExpression setValuesExpression) {
                Expression expr = setValuesExpression.getExpression();
                if (expr instanceof AnnotationExpression) {
                    MatchVisitor.this.matchName(((AnnotationExpression)expr).getName());
                }
                SettingsBlock block = setValuesExpression.getSettingsBlock();
                MatchVisitor.this.handlePropertyBlock(block);
                return false;
            }

            public boolean visit(Assignment assignment) {
                Expression expr = assignment.getRightHandSide();
                expr.accept((IASTVisitor)new AbstractASTExpressionVisitor(){

                    public boolean visitName(Name name) {
                        MatchVisitor.this.matchName(name);
                        return false;
                    }

                    public boolean visitExpression(Expression expression) {
                        return true;
                    }
                });
                assignment.getLeftHandSide().accept((IASTVisitor)new AbstractASTExpressionVisitor(){

                    public boolean visitName(Name name) {
                        MatchVisitor.this.matchName(name);
                        return false;
                    }
                });
                return false;
            }
        });
    }

    private void handlePropertyBlock(SettingsBlock block) {
        List decls = block.getSettings();
        Iterator iter = decls.iterator();
        while (iter.hasNext()) {
            this.handleProperty((Node)iter.next());
        }
    }

    public boolean visit(NestedFunction function) {
        if ((this.matchSet.matchContainer & 0xA) != 0 || (this.matchSet.matchContainer & 2) != 0) {
            int level = this.matchSet.isMatchingNestedFunctionPart(function);
            if (level == 2) {
                this.matchSet.addTrustedMatch((Node)function);
            } else if (level == 3) {
                this.matchSet.addInaccurateMatch((Node)function);
            }
        }
        function.accept((IASTVisitor)new SpecialVisitor(this));
        return super.visit(function);
    }

    public boolean visit(Library library) {
        this.visitPart((Part)library);
        return super.visit(library);
    }

    public boolean visit(Handler handler) {
        this.visitPart((Part)handler);
        return super.visit(handler);
    }

    public boolean visit(Service service) {
        this.visitPart((Part)service);
        Iterator iter = service.getImplementedInterfaces().iterator();
        while (iter.hasNext()) {
            this.matchName((Name)iter.next());
        }
        int cfr_ignored_0 = this.matchSet.matchContainer;
        return super.visit(service);
    }

    public boolean visit(Interface intrface) {
        this.visitPart((Part)intrface);
        return super.visit(intrface);
    }

    public boolean visit(Program program) {
        this.visitPart((Part)program);
        return super.visit(program);
    }

    public boolean visit(Class eglClass) {
        this.visitPart((Part)eglClass);
        return super.visit(eglClass);
    }

    public boolean visit(org.eclipse.edt.compiler.core.ast.Record record) {
        this.visitPart((Part)record);
        return super.visit(record);
    }

    public void visitPart(Part part) {
        if ((this.matchSet.matchContainer & 2) != 0) {
            int level = this.matchSet.isMatchingPart(part);
            if (level == 2) {
                this.matchSet.addTrustedMatch((Node)part);
            } else if (level == 3) {
                this.matchSet.addInaccurateMatch((Node)part);
            }
        }
        part.accept((IASTVisitor)new SpecialVisitor(this));
    }

    protected void matchList(List list) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            this.matchSet.addTrustedMatch((Node)iter.next());
        }
    }

    protected void matchField(Type type, Name name) {
        int level = this.matchSet.getMatchingLevel((Node)type);
        if (level != 1) {
            // empty if block
        }
    }

    protected void matchField(Type type, List list) {
        int level = this.matchSet.getMatchingLevel((Node)type);
        if (level != 1) {
            // empty if block
        }
    }

    private boolean isAny(Type type) {
        Type baseType = type.getBaseType();
        org.eclipse.edt.mof.egl.Type typeBinding = baseType.resolveType();
        if (typeBinding != null) {
            return TypeUtils.Type_ANY.equals(typeBinding);
        }
        return false;
    }

    public boolean visit(ClassDataDeclaration classDataDeclaration) {
        if (classDataDeclaration.getSettingsBlockOpt() != null) {
            classDataDeclaration.getSettingsBlockOpt().accept((IASTVisitor)this);
        }
        if (classDataDeclaration.getInitializer() != null) {
            classDataDeclaration.getInitializer().accept((IASTVisitor)this);
        }
        classDataDeclaration.getType().accept((IASTVisitor)this);
        return false;
    }

    public boolean visit(FunctionDataDeclaration functionDataDeclaration) {
        if (functionDataDeclaration.getSettingsBlockOpt() != null) {
            functionDataDeclaration.getSettingsBlockOpt().accept((IASTVisitor)this);
        }
        if (functionDataDeclaration.getInitializer() != null) {
            functionDataDeclaration.getInitializer().accept((IASTVisitor)this);
        }
        functionDataDeclaration.getType().accept((IASTVisitor)this);
        return false;
    }

    public void endVisit(FunctionDataDeclaration functionDataDeclaration) {
        boolean bContinue;
        boolean bl = bContinue = !this.isAny(functionDataDeclaration.getType());
        if (bContinue && this.binding != null) {
            this.matchSet.addTrustedMatch((Node)functionDataDeclaration.getType().getBaseType());
        }
        this.binding = null;
    }

    public void endVisit(FunctionParameter functionParameter) {
        if (this.binding != null) {
            this.matchSet.addTrustedMatch((Node)functionParameter.getType().getBaseType());
        }
        this.binding = null;
    }

    public void endVisit(ReturnsDeclaration returnsDeclaration) {
        if (this.binding != null) {
            this.matchSet.addTrustedMatch((Node)returnsDeclaration.getType().getBaseType());
        }
        this.binding = null;
    }

    public void endVisit(ClassDataDeclaration classDataDeclaration) {
        boolean bContinue;
        boolean bl = bContinue = !this.isAny(classDataDeclaration.getType());
        if (bContinue && this.binding != null) {
            this.matchSet.addTrustedMatch((Node)classDataDeclaration.getType().getBaseType());
        }
        this.binding = null;
    }

    public void endVisit(FunctionInvocation functionInvocation) {
        if (this.binding != null) {
            this.matchSet.addTrustedMatch((Node)functionInvocation.getTarget());
        } else if (functionInvocation.getTarget().isName()) {
            Name target = (Name)functionInvocation.getTarget();
            org.eclipse.edt.mof.egl.Type typeBinding = target.resolveType();
            if (typeBinding != null) {
                if (typeBinding instanceof FunctionPart) {
                    int level = this.matchSet.isMatchingFunctionType(target, (FunctionPart)typeBinding);
                    if (level == 2) {
                        this.matchSet.addTrustedMatch((Node)target);
                    } else if (level == 3) {
                        this.matchSet.addInaccurateMatch((Node)target);
                    }
                    return;
                }
                if (typeBinding instanceof org.eclipse.edt.mof.egl.Delegate) {
                    int level = this.matchSet.isMatchingType(target, (org.eclipse.edt.mof.egl.Part)((org.eclipse.edt.mof.egl.Delegate)typeBinding));
                    if (level == 2) {
                        this.matchSet.addTrustedMatch((Node)target);
                    }
                    return;
                }
            } else {
                Member m = target.resolveMember();
                if (m instanceof FunctionMember) {
                    int level = this.matchSet.isMatchingFunctionType(target, null);
                    if (level == 2) {
                        this.matchSet.addTrustedMatch((Node)target);
                    } else if (level == 3) {
                        this.matchSet.addInaccurateMatch((Node)target);
                    }
                    return;
                }
            }
            if (this.matchSet.getMatchingLevel((Node)target) == 1) {
                this.matchSet.addInaccurateMatch((Node)target);
            }
        }
        this.binding = null;
    }

    public void endVisit(StructureItem embeddedRecordStructureItem) {
        boolean bContinue;
        boolean bl = bContinue = embeddedRecordStructureItem.getType() != null && !this.isAny(embeddedRecordStructureItem.getType());
        if (bContinue && this.binding != null) {
            if (this.binding instanceof StructuredRecord || this.binding instanceof Record) {
                this.matchSet.addTrustedMatch((Node)embeddedRecordStructureItem.getType().getBaseType());
            } else {
                this.matchSet.addTrustedMatch((Node)embeddedRecordStructureItem.getType().getBaseType());
            }
        }
        this.binding = null;
    }

    public boolean visit(UseStatement useStatement) {
        List useTargets = useStatement.getNames();
        int i = 0;
        while (i < useTargets.size()) {
            if (useTargets.get(i) instanceof QualifiedName) {
                ((Name)useTargets.get(i)).accept((IASTVisitor)this);
            } else {
                this.matchName((Name)useTargets.get(i));
            }
            ++i;
        }
        return false;
    }

    public boolean visitExpression(Expression dataAccess) {
        return true;
    }

    public boolean visit(NameType nameType) {
        nameType.accept((IASTVisitor)new AbstractASTExpressionVisitor(){

            public boolean visitName(Name name) {
                org.eclipse.edt.mof.egl.Type type = name.resolveType();
                if (type != null) {
                    if (type instanceof org.eclipse.edt.mof.egl.Part && MatchVisitor.this.matchSet.isMatchingType(name, (org.eclipse.edt.mof.egl.Part)type) == 2) {
                        MatchVisitor.this.binding = (org.eclipse.edt.mof.egl.Part)type;
                        return false;
                    }
                } else if (MatchVisitor.this.matchSet.getMatchingLevel((Node)name) == 1) {
                    MatchVisitor.this.matchSet.addInaccurateMatch((Node)name);
                }
                return true;
            }
        });
        return false;
    }

    public boolean visit(IsAExpression isa) {
        isa.getExpression().accept((IASTVisitor)this);
        return false;
    }

    public boolean visit(AsExpression as) {
        as.getExpression().accept((IASTVisitor)this);
        return false;
    }

    public boolean visit(NewExpression newExpr) {
        Type root = newExpr.getType().getBaseType();
        if (root.isNameType()) {
            List list = ((NameType)root).getArguments();
            for (Node node : list) {
                node.accept((IASTVisitor)this);
            }
        }
        return false;
    }

    public boolean visitName(Name name) {
        org.eclipse.edt.mof.egl.Type type = name.resolveType();
        if (type instanceof AnnotationType) {
            this.matchName(name, (Element)type);
        }
        return false;
    }

    public boolean visit(QualifiedName name) {
        int level = this.matchSet.getMatchingLevel((Node)name);
        if (level == 1 || level == 2) {
            org.eclipse.edt.mof.egl.Type element = name.resolveType();
            if (element == null) {
                element = name.resolveMember();
            }
            QualifiedName matchNode = name;
            QualifiedName loopname = name;
            while (loopname.isQualifiedName()) {
                level = this.matchSet.getMatchingLevel((Node)(loopname = loopname.getQualifier()));
                if (level != 1 && level != 2) break;
                matchNode = loopname;
                element = loopname.resolveType();
                if (!(element instanceof Record) && !(element instanceof StructuredRecord)) continue;
                element = null;
            }
            if (element == null) {
                return false;
            }
            this.matchName((Name)matchNode, (Element)element);
        }
        return false;
    }

    private boolean isMethodName(Expression dataAccess) {
        return false;
    }

    private boolean isFunctionArgument(Expression dataAccess) {
        boolean result = false;
        return result;
    }

    private Expression getDataAccessHelper(Expression dataAccess) {
        return null;
    }

    private Statement getStatement(Expression dataAccess) {
        return null;
    }

    public boolean visit(CallStatement callStatement) {
        Expression program = callStatement.getInvocationTarget();
        if (program.isName()) {
            this.matchName((Name)program);
        }
        return false;
    }

    protected void matchName(Name name) {
        org.eclipse.edt.mof.egl.Type e = name.resolveType();
        if (e == null) {
            e = name.resolveMember();
        }
        this.matchName(name, (Element)e);
    }

    protected void matchName(Name name, Element element) {
        int level = this.matchSet.getMatchingLevel((Node)name);
        if (level == 1 || level == 2) {
            if (element != null) {
                if (element instanceof FunctionMember) {
                    level = this.matchSet.isMatchingFunctionType(name, null);
                    if (level == 2) {
                        this.matchSet.addTrustedMatch((Node)name);
                    } else if (level == 3) {
                        this.matchSet.addInaccurateMatch((Node)name);
                    }
                    return;
                }
                if (element instanceof org.eclipse.edt.mof.egl.Part) {
                    level = this.matchSet.isMatchingType(name, (org.eclipse.edt.mof.egl.Part)element);
                    if (level == 2) {
                        this.matchSet.addTrustedMatch((Node)name);
                    } else if (level == 3) {
                        this.matchSet.addInaccurateMatch((Node)name);
                    }
                    return;
                }
                return;
            }
            this.matchSet.addInaccurateMatch((Node)name);
        }
    }

    private class SpecialVisitor
    extends AbstractASTVisitor {
        private MatchVisitor visitor = null;

        public SpecialVisitor(MatchVisitor mvisitor) {
            this.visitor = mvisitor;
        }

        private void handleType(Type type) {
            Type baseType = type.getBaseType();
            if (baseType.isNameType()) {
                this.visitor.visit((NameType)baseType);
                if (MatchVisitor.this.binding != null) {
                    MatchVisitor.this.matchSet.addTrustedMatch((Node)baseType);
                    MatchVisitor.this.binding = null;
                }
            }
        }

        public boolean visit(IsAExpression isa) {
            Type type = isa.getType();
            this.handleType(type);
            return true;
        }

        public boolean visit(AsExpression as) {
            if (as.hasType()) {
                Type type = as.getType();
                this.handleType(type);
            }
            return true;
        }

        public boolean visit(NewExpression newExpr) {
            Type type = newExpr.getType();
            this.handleType(type);
            Type root = type.getBaseType();
            if (root.isNameType()) {
                List list = ((NameType)root).getArguments();
                for (Node node : list) {
                    node.accept((IASTVisitor)new SpecialVisitor(this.visitor));
                }
            }
            if (newExpr.hasSettingsBlock()) {
                newExpr.getSettingsBlock().accept((IASTVisitor)new SpecialVisitor(this.visitor));
            }
            newExpr.accept((IASTVisitor)new AbstractASTVisitor(){

                public boolean visit(QualifiedName name) {
                    name.accept((IASTVisitor)SpecialVisitor.this.visitor);
                    return false;
                }
            });
            return false;
        }
    }
}

