/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.search.matching;

import java.io.IOException;
import org.eclipse.edt.compiler.core.ast.ArrayType;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.utils.CharOperation;
import org.eclipse.edt.ide.core.internal.model.index.IEntryResult;
import org.eclipse.edt.ide.core.internal.model.index.impl.IndexInput;
import org.eclipse.edt.ide.core.internal.model.index.impl.IndexedFile;
import org.eclipse.edt.ide.core.internal.model.indexing.AbstractIndexer;
import org.eclipse.edt.ide.core.internal.search.IIndexSearchRequestor;
import org.eclipse.edt.ide.core.internal.search.matching.FunctionPattern;
import org.eclipse.edt.ide.core.model.IIndexConstants;
import org.eclipse.edt.ide.core.model.IMember;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;

public class FunctionReferencePattern
extends FunctionPattern {
    IPart declaringPart;

    public FunctionReferencePattern(char[] selector, int matchMode, boolean isCaseSensitive, char[] declaringQualification, IPart declaringPart) {
        super(matchMode, isCaseSensitive);
        this.selector = isCaseSensitive ? selector : CharOperation.toLowerCase((char[])selector);
        this.declaringQualification = isCaseSensitive ? declaringQualification : CharOperation.toLowerCase((char[])declaringQualification);
        this.declaringPart = declaringPart;
        this.needsResolve = this.needsResolve();
    }

    @Override
    public void decodeIndexEntry(IEntryResult entryResult) {
        char[] word = entryResult.getWord();
        int size = word.length;
        int lastSeparatorIndex = CharOperation.lastIndexOf((char)'/', (char[])word);
        if (CharOperation.prefixEquals((char[])IIndexConstants.REF, (char[])word)) {
            this.decodedParameterCount = 0;
            this.decodedSelector = CharOperation.subarray((char[])word, (int)REF.length, (int)word.length);
        } else {
            this.decodedParameterCount = Integer.parseInt(new String(word, lastSeparatorIndex + 1, size - lastSeparatorIndex - 1));
            this.decodedSelector = CharOperation.subarray((char[])word, (int)FUNCTION_REF.length, (int)lastSeparatorIndex);
        }
    }

    @Override
    public void feedIndexRequestor(IIndexSearchRequestor requestor, int detailLevel, int[] references, IndexInput input, IEGLSearchScope scope) throws IOException {
        int i = 0;
        int max = references.length;
        while (i < max) {
            String path;
            IndexedFile file = input.getIndexedFile(references[i]);
            if (file != null && scope.encloses(path = IndexedFile.convertPath(file.getPath()))) {
                requestor.acceptFunctionReference(path, this.decodedSelector, this.decodedParameterCount);
            }
            ++i;
        }
    }

    @Override
    public String getPatternName() {
        return "FunctionReferencePattern: ";
    }

    @Override
    public char[] indexEntryPrefix() {
        return AbstractIndexer.bestMethodReferencePrefix(this.selector, -1, this.matchMode, this.isCaseSensitive);
    }

    @Override
    protected int matchContainer() {
        return 12;
    }

    @Override
    public int matchLevel(Node node, boolean resolve) {
        if (node instanceof ArrayType) {
            node = ((ArrayType)node).getBaseType();
        }
        if (node instanceof Name && this.matchesName(this.selector, ((Name)node).getCaseSensitiveIdentifier().toCharArray())) {
            return 1;
        }
        return 0;
    }

    @Override
    public int matchLevel(IMember member, boolean resolve) {
        if (!this.matchesName(this.selector, member.getElementName().toCharArray())) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getPatternType() {
        return 2;
    }
}

