/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.search;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.edt.ide.core.internal.model.index.IIndex;
import org.eclipse.edt.ide.core.internal.model.indexing.EGLReadWriteMonitor;
import org.eclipse.edt.ide.core.internal.model.indexing.IndexManager;
import org.eclipse.edt.ide.core.internal.model.indexing.IndexSelector;
import org.eclipse.edt.ide.core.internal.model.search.processing.IJob;
import org.eclipse.edt.ide.core.internal.model.search.processing.JobManager;
import org.eclipse.edt.ide.core.internal.search.IIndexSearchRequestor;
import org.eclipse.edt.ide.core.internal.search.matching.SearchPattern;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;

public class PatternSearchJob
implements IJob {
    protected SearchPattern pattern;
    protected IEGLSearchScope scope;
    protected IEGLElement focus;
    protected IIndexSearchRequestor requestor;
    protected IndexManager indexManager;
    protected int detailLevel;
    protected IndexSelector indexSelector;
    protected boolean isPolymorphicSearch;
    protected long executionTime = 0L;

    public PatternSearchJob(SearchPattern pattern, IEGLSearchScope scope, int detailLevel, IIndexSearchRequestor requestor, IndexManager indexManager) {
        this(pattern, scope, null, false, detailLevel, requestor, indexManager);
    }

    public PatternSearchJob(SearchPattern pattern, IEGLSearchScope scope, IEGLElement focus, boolean isPolymorphicSearch, int detailLevel, IIndexSearchRequestor requestor, IndexManager indexManager) {
        this.pattern = pattern;
        this.scope = scope;
        this.focus = focus;
        this.isPolymorphicSearch = isPolymorphicSearch;
        this.detailLevel = detailLevel;
        this.requestor = requestor;
        this.indexManager = indexManager;
    }

    @Override
    public boolean belongsTo(String jobFamily) {
        return true;
    }

    @Override
    public void cancel() {
    }

    @Override
    public boolean execute(IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        boolean isComplete = true;
        this.executionTime = 0L;
        if (this.indexSelector == null) {
            this.indexSelector = new IndexSelector(this.scope.enclosingProjects(), this.focus, this.isPolymorphicSearch, this.indexManager);
        }
        IIndex[] searchIndexes = this.indexSelector.getIndexes();
        try {
            int max = searchIndexes.length;
            if (progressMonitor != null) {
                progressMonitor.beginTask("", max);
            }
            int i = 0;
            while (i < max) {
                isComplete &= this.search(searchIndexes[i], progressMonitor);
                if (progressMonitor != null) {
                    if (progressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    progressMonitor.worked(1);
                }
                ++i;
            }
            if (JobManager.VERBOSE) {
                JobManager.verbose("-> execution time: " + this.executionTime + "ms - " + this);
            }
            boolean bl = isComplete;
            return bl;
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.done();
            }
        }
    }

    @Override
    public boolean isReadyToRun() {
        if (this.indexSelector == null) {
            this.indexSelector = new IndexSelector(this.scope.enclosingProjects(), this.focus, this.isPolymorphicSearch, this.indexManager);
            this.indexSelector.getIndexes();
        }
        return true;
    }

    public boolean search(IIndex index, IProgressMonitor progressMonitor) {
        long start;
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (index == null) {
            return true;
        }
        EGLReadWriteMonitor monitor = this.indexManager.getMonitorFor(index);
        if (monitor == null) {
            return true;
        }
        try {
            monitor.enterRead();
            if (index.hasChanged()) {
                try {
                    try {
                        monitor.exitRead();
                        monitor.enterWrite();
                        this.indexManager.saveIndex(index);
                    }
                    catch (IOException iOException) {
                        monitor.exitWriteEnterRead();
                        monitor.exitRead();
                        return false;
                    }
                }
                finally {
                    monitor.exitWriteEnterRead();
                }
            }
            start = System.currentTimeMillis();
        }
        catch (IOException iOException) {
            return false;
        }
        finally {
            monitor.exitRead();
        }
        this.pattern.findIndexMatches(index, this.requestor, this.detailLevel, progressMonitor, this.scope);
        this.executionTime += System.currentTimeMillis() - start;
        return true;
    }

    public String toString() {
        return "searching " + this.pattern.toString();
    }
}

