/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.search;

import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.ide.core.internal.model.EGLModelManager;
import org.eclipse.edt.ide.core.internal.search.EGLSearchScope;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLElementDelta;
import org.eclipse.edt.ide.core.model.IEGLProject;

public class EGLWorkspaceScope
extends EGLSearchScope {
    protected boolean needsInitialize;

    public EGLWorkspaceScope() {
        EGLModelManager.getEGLModelManager().rememberScope(this);
    }

    @Override
    public boolean encloses(IEGLElement element) {
        return true;
    }

    @Override
    public boolean encloses(String resourcePathString) {
        return true;
    }

    @Override
    public IPath[] enclosingProjects() {
        if (this.needsInitialize) {
            this.initialize();
        }
        return super.enclosingProjects();
    }

    public boolean equals(Object o) {
        return o instanceof EGLWorkspaceScope;
    }

    public int hashCode() {
        return EGLWorkspaceScope.class.hashCode();
    }

    @Override
    public void initialize() {
        super.initialize();
        try {
            IEGLProject[] projects = EGLModelManager.getEGLModelManager().getEGLModel().getEGLProjects();
            int i = 0;
            int length = projects.length;
            while (i < length) {
                this.add(projects[i], false, new HashSet(2));
                ++i;
            }
        }
        catch (EGLModelException eGLModelException) {}
        this.needsInitialize = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void processDelta(IEGLElementDelta delta) {
        if (this.needsInitialize) {
            return;
        }
        IEGLElement element = delta.getElement();
        block0 : switch (element.getElementType()) {
            case 1: {
                IEGLElementDelta[] children = delta.getAffectedChildren();
                int i = 0;
                int length = children.length;
                while (i < length) {
                    IEGLElementDelta child = children[i];
                    this.processDelta(child);
                    ++i;
                }
                return;
            }
            case 2: {
                int kind = delta.getKind();
                switch (kind) {
                    case 1: 
                    case 2: {
                        this.needsInitialize = true;
                        return;
                    }
                    case 4: {
                        IEGLElementDelta[] children = delta.getAffectedChildren();
                        int i = 0;
                        int length = children.length;
                        while (i < length) {
                            IEGLElementDelta child = children[i];
                            this.processDelta(child);
                            ++i;
                        }
                        return;
                    }
                }
                return;
            }
            case 3: {
                int kind = delta.getKind();
                switch (kind) {
                    case 1: 
                    case 2: {
                        this.needsInitialize = true;
                        break block0;
                    }
                    case 4: {
                        int flags = delta.getFlags();
                        if ((flags & 0x40) <= 0 && (flags & 0x80) <= 0) return;
                        this.needsInitialize = true;
                    }
                }
            }
        }
    }

    @Override
    public String toString() {
        return "EGLWorkspaceScope";
    }
}

