/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.indexing;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.ide.core.internal.model.index.IIndex;
import org.eclipse.edt.ide.core.internal.model.indexing.IndexManager;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLModel;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;

public class IndexSelector {
    IEGLElement focus;
    IndexManager indexManager;
    IPath[] indexKeys;
    boolean isPolymorphicSearch;
    IPath[] projectsAndJars;

    public IndexSelector(IPath[] enclosingProjects, IEGLElement focus, boolean isPolymorphicSearch, IndexManager indexManager) {
        this.projectsAndJars = enclosingProjects;
        this.focus = focus;
        this.indexManager = indexManager;
        this.isPolymorphicSearch = isPolymorphicSearch;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean canSeeFocus(IEGLElement focus, boolean isPolymorphicSearch, IPath projectOrJarPath) {
        try {
            IEGLModel model = focus.getEGLModel();
            IEGLProject project = IndexSelector.getEGLProject(projectOrJarPath, model);
            if (project == null) {
                IEGLProject[] allProjects = model.getEGLProjects();
                int i = 0;
                int length = allProjects.length;
                while (i < length) {
                    IEGLProject otherProject = allProjects[i];
                    IEGLPathEntry[] entries = otherProject.getResolvedEGLPath(true);
                    int j = 0;
                    int length2 = entries.length;
                    while (j < length2) {
                        IEGLPathEntry entry = entries[j];
                        if (entry.getEntryKind() == 1 && entry.getPath().equals((Object)projectOrJarPath) && IndexSelector.canSeeFocus(focus, isPolymorphicSearch, otherProject.getPath())) {
                            return true;
                        }
                        ++j;
                    }
                    ++i;
                }
                return false;
            }
            EGLProject focusProject = (EGLProject)focus;
            if (isPolymorphicSearch) {
                IEGLPathEntry[] entries = focusProject.getExpandedEGLPath(true);
                int i = 0;
                int length = entries.length;
                while (i < length) {
                    IEGLPathEntry entry = entries[i];
                    if (entry.getEntryKind() == 2 && entry.getPath().equals((Object)projectOrJarPath)) {
                        return true;
                    }
                    ++i;
                }
            }
            if (focus.equals(project)) {
                return true;
            }
            IPath focusPath = focusProject.getProject().getFullPath();
            IEGLPathEntry[] entries = ((EGLProject)project).getExpandedEGLPath(true);
            int i = 0;
            int length = entries.length;
            while (i < length) {
                IEGLPathEntry entry = entries[i];
                if (entry.getEntryKind() == 2 && entry.getPath().equals((Object)focusPath)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        catch (EGLModelException eGLModelException) {
            return false;
        }
    }

    private void initializeIndexKeys() {
        ArrayList<IPath> requiredIndexKeys = new ArrayList<IPath>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IEGLElement projectOrJarFocus = this.focus == null ? null : IndexSelector.getProjectOrJar(this.focus);
        int i = 0;
        while (i < this.projectsAndJars.length) {
            IPath location;
            IPath path = this.projectsAndJars[i];
            if ((root.getProject(path.lastSegment()).exists() || path.segmentCount() <= 1 || (location = root.getFile(path).getLocation()) != null && new File(location.toOSString()).exists() || new File(path.toOSString()).exists()) && (projectOrJarFocus == null || IndexSelector.canSeeFocus(projectOrJarFocus, this.isPolymorphicSearch, path)) && requiredIndexKeys.indexOf(path) == -1) {
                requiredIndexKeys.add(path);
            }
            ++i;
        }
        this.indexKeys = new IPath[requiredIndexKeys.size()];
        requiredIndexKeys.toArray(this.indexKeys);
    }

    public IIndex[] getIndexes() {
        if (this.indexKeys == null) {
            this.initializeIndexKeys();
        }
        int length = this.indexKeys.length;
        IIndex[] indexes = new IIndex[length];
        int count = 0;
        int i = 0;
        while (i < length) {
            IIndex index = this.indexManager.getIndex(this.indexKeys[i], true, false);
            if (index != null) {
                indexes[count++] = index;
            }
            ++i;
        }
        if (count != length) {
            IIndex[] iIndexArray = indexes;
            indexes = new IIndex[count];
            System.arraycopy(iIndexArray, 0, indexes, 0, count);
        }
        return indexes;
    }

    private static IEGLProject getEGLProject(IPath path, IEGLModel model) {
        IEGLProject project = model.getEGLProject(path.lastSegment());
        if (project.exists()) {
            return project;
        }
        return null;
    }

    public static IEGLElement getProjectOrJar(IEGLElement element) {
        while (!(element instanceof IEGLProject)) {
            element = element.getParent();
        }
        return element;
    }
}

