/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.index.impl;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.edt.ide.core.internal.model.index.IDocument;
import org.eclipse.edt.ide.core.internal.model.index.IEntryResult;
import org.eclipse.edt.ide.core.internal.model.index.IIndex;
import org.eclipse.edt.ide.core.internal.model.index.IIndexer;
import org.eclipse.edt.ide.core.internal.model.index.IQueryResult;
import org.eclipse.edt.ide.core.internal.model.index.impl.BlocksIndexInput;
import org.eclipse.edt.ide.core.internal.model.index.impl.BlocksIndexOutput;
import org.eclipse.edt.ide.core.internal.model.index.impl.InMemoryIndex;
import org.eclipse.edt.ide.core.internal.model.index.impl.IndexInput;
import org.eclipse.edt.ide.core.internal.model.index.impl.IndexedFile;
import org.eclipse.edt.ide.core.internal.model.index.impl.IndexerOutput;
import org.eclipse.edt.ide.core.internal.model.index.impl.Int;
import org.eclipse.edt.ide.core.internal.model.index.impl.MergeFactory;
import org.eclipse.edt.ide.core.internal.model.index.impl.SimpleIndexInput;

public class Index
implements IIndex {
    public static final int MAX_FOOTPRINT = 10000000;
    protected InMemoryIndex addsIndex;
    protected IndexInput addsIndexInput;
    protected int state = 1;
    protected Map removedInAdds;
    protected Map removedInOld;
    protected static final int CAN_MERGE = 0;
    protected static final int MERGED = 1;
    private File indexFile;
    public String toString;

    public Index(File indexDirectory, boolean reuseExistingFile) throws IOException {
        this(indexDirectory, ".index", reuseExistingFile);
    }

    public Index(File indexDirectory, String indexName, boolean reuseExistingFile) throws IOException {
        this.indexFile = new File(indexDirectory, indexName);
        this.initialize(reuseExistingFile);
    }

    public Index(String indexName, boolean reuseExistingFile) throws IOException {
        this(indexName, null, reuseExistingFile);
    }

    public Index(String indexName, String toString, boolean reuseExistingFile) throws IOException {
        this.indexFile = new File(indexName);
        this.toString = toString;
        this.initialize(reuseExistingFile);
    }

    @Override
    public void add(IDocument document, IIndexer indexer) throws IOException {
        IndexedFile indexedFile;
        if (this.timeToMerge()) {
            this.merge();
        }
        if ((indexedFile = this.addsIndex.getIndexedFile(document.getName())) != null) {
            this.remove(indexedFile, 0);
        }
        IndexerOutput output = new IndexerOutput(this.addsIndex);
        indexer.index(document, output);
        this.state = 0;
    }

    protected boolean canMerge() {
        return this.state == 0;
    }

    @Override
    public void empty() throws IOException {
        if (this.indexFile.exists()) {
            this.indexFile.delete();
            InMemoryIndex mainIndex = new InMemoryIndex();
            BlocksIndexOutput mainIndexOutput = new BlocksIndexOutput(this.indexFile);
            if (!this.indexFile.exists()) {
                mainIndex.save(mainIndexOutput);
            }
        }
        this.addsIndex = new InMemoryIndex();
        this.addsIndexInput = new SimpleIndexInput(this.addsIndex);
        this.removedInAdds = new HashMap(11);
        this.removedInOld = new HashMap(11);
    }

    @Override
    public File getIndexFile() {
        return this.indexFile;
    }

    @Override
    public int getNumDocuments() throws IOException {
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            ((IndexInput)input).open();
            int n = ((IndexInput)input).getNumFiles();
            return n;
        }
        finally {
            ((IndexInput)input).close();
        }
    }

    @Override
    public int getNumWords() throws IOException {
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            ((IndexInput)input).open();
            int n = ((IndexInput)input).getNumWords();
            return n;
        }
        finally {
            ((IndexInput)input).close();
        }
    }

    @Override
    public String getPath(int documentNumber) throws IOException {
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            ((IndexInput)input).open();
            IndexedFile file = ((IndexInput)input).getIndexedFile(documentNumber);
            if (file == null) {
                return null;
            }
            String string = file.getPath();
            return string;
        }
        finally {
            ((IndexInput)input).close();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.canMerge();
    }

    public void initialize(boolean reuseExistingFile) throws IOException {
        this.addsIndex = new InMemoryIndex();
        this.addsIndexInput = new SimpleIndexInput(this.addsIndex);
        this.removedInAdds = new HashMap(11);
        this.removedInOld = new HashMap(11);
        if (reuseExistingFile && this.indexFile.exists()) {
            BlocksIndexInput mainIndexInput = new BlocksIndexInput(this.indexFile);
            try {
                ((IndexInput)mainIndexInput).open();
            }
            catch (IOException e) {
                BlocksIndexInput input = mainIndexInput;
                try {
                    input.opened = true;
                    input.close();
                }
                finally {
                    input.opened = false;
                }
                this.indexFile.delete();
                mainIndexInput = null;
                throw e;
            }
            ((IndexInput)mainIndexInput).close();
        } else {
            InMemoryIndex mainIndex = new InMemoryIndex();
            BlocksIndexOutput mainIndexOutput = new BlocksIndexOutput(this.indexFile);
            mainIndex.save(mainIndexOutput);
        }
    }

    protected void merge() throws IOException {
        File tempFile = new File(String.valueOf(this.indexFile.getAbsolutePath()) + "TempVA");
        BlocksIndexInput mainIndexInput = new BlocksIndexInput(this.indexFile);
        BlocksIndexOutput tempIndexOutput = new BlocksIndexOutput(tempFile);
        try {
            new MergeFactory(mainIndexInput, this.addsIndexInput, tempIndexOutput, this.removedInOld, this.removedInAdds).merge();
            File mainIndexFile = (File)((IndexInput)mainIndexInput).getSource();
            File tempIndexFile = (File)tempIndexOutput.getDestination();
            mainIndexFile.delete();
            tempIndexFile.renameTo(mainIndexFile);
        }
        finally {
            this.removedInAdds.clear();
            this.removedInOld.clear();
            this.addsIndex.init();
            this.addsIndexInput = new SimpleIndexInput(this.addsIndex);
            this.state = 1;
        }
    }

    @Override
    public IQueryResult[] query(String word) throws IOException {
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            IQueryResult[] iQueryResultArray = ((IndexInput)input).query(word);
            return iQueryResultArray;
        }
        finally {
            ((IndexInput)input).close();
        }
    }

    @Override
    public IEntryResult[] queryEntries(char[] prefix) throws IOException {
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            IEntryResult[] iEntryResultArray = ((IndexInput)input).queryEntriesPrefixedBy(prefix);
            return iEntryResultArray;
        }
        finally {
            ((IndexInput)input).close();
        }
    }

    @Override
    public IQueryResult[] queryInDocumentNames(String word) throws IOException {
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            IQueryResult[] iQueryResultArray = ((IndexInput)input).queryInDocumentNames(word);
            return iQueryResultArray;
        }
        finally {
            ((IndexInput)input).close();
        }
    }

    @Override
    public IQueryResult[] queryPrefix(char[] prefix) throws IOException {
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            IQueryResult[] iQueryResultArray = ((IndexInput)input).queryFilesReferringToPrefix(prefix);
            return iQueryResultArray;
        }
        finally {
            ((IndexInput)input).close();
        }
    }

    @Override
    public void remove(String documentName) throws IOException {
        IndexedFile file = this.addsIndex.getIndexedFile(documentName);
        if (file != null) {
            Int lastRemoved = (Int)this.removedInAdds.get(documentName);
            if (lastRemoved != null) {
                int fileNum = file.getFileNumber();
                if (lastRemoved.value < fileNum) {
                    lastRemoved.value = fileNum;
                }
            } else {
                this.removedInAdds.put(documentName, new Int(file.getFileNumber()));
            }
        } else {
            this.removedInOld.put(documentName, new Int(1));
        }
        this.state = 0;
    }

    protected void remove(IndexedFile file, int index) throws IOException {
        String name = file.getPath();
        if (index == 0) {
            Int lastRemoved = (Int)this.removedInAdds.get(name);
            if (lastRemoved != null) {
                if (lastRemoved.value < file.getFileNumber()) {
                    lastRemoved.value = file.getFileNumber();
                }
            } else {
                this.removedInAdds.put(name, new Int(file.getFileNumber()));
            }
        } else if (index == 1) {
            this.removedInOld.put(name, new Int(1));
        } else {
            throw new Error();
        }
        this.state = 0;
    }

    @Override
    public void save() throws IOException {
        if (this.canMerge()) {
            this.merge();
        }
    }

    protected boolean timeToMerge() {
        return this.addsIndex.getFootprint() >= 10000000L;
    }

    public String toString() {
        String str = this.toString;
        if (str == null) {
            str = super.toString();
        }
        str = String.valueOf(str) + "(length: " + this.getIndexFile().length() + ")";
        return str;
    }
}

