/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import org.eclipse.edt.ide.core.internal.model.Assert;
import org.eclipse.edt.ide.core.internal.model.EGLElement;
import org.eclipse.edt.ide.core.internal.model.SourceFunctionElementInfo;
import org.eclipse.edt.ide.core.internal.model.SourcePart;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.Flags;
import org.eclipse.edt.ide.core.model.IFunction;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.Signature;

public class SourceFunction
extends SourcePart
implements IFunction {
    protected String[] fParameterTypes;
    protected static final String[] fgEmptyList = new String[0];

    protected SourceFunction(IPart parent, String name, String[] parameterTypes) {
        super(10, parent, name);
        Assert.isTrue(name.indexOf(46) == -1);
        this.fParameterTypes = parameterTypes == null ? fgEmptyList : parameterTypes;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && Util.equalArraysOrNull(this.fParameterTypes, ((SourceFunction)o).fParameterTypes);
    }

    @Override
    public String getHandleMemento() {
        StringBuffer buff = new StringBuffer(((EGLElement)this.getParent()).getHandleMemento());
        buff.append(this.getHandleMementoDelimiter());
        buff.append(this.getElementName());
        int i = 0;
        while (i < this.fParameterTypes.length) {
            buff.append(this.getHandleMementoDelimiter());
            buff.append(this.fParameterTypes[i]);
            ++i;
        }
        return buff.toString();
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '~';
    }

    @Override
    public int getNumberOfParameters() {
        return this.fParameterTypes == null ? 0 : this.fParameterTypes.length;
    }

    @Override
    public String[] getParameterNames() throws EGLModelException {
        SourceFunctionElementInfo info = (SourceFunctionElementInfo)this.getElementInfo();
        char[][] names = info.getArgumentNames();
        if (names == null || names.length == 0) {
            return fgEmptyList;
        }
        String[] strings = new String[names.length];
        int i = 0;
        while (i < names.length) {
            strings[i] = new String(names[i]);
            ++i;
        }
        return strings;
    }

    @Override
    public String[] getParameterTypes() {
        return this.fParameterTypes;
    }

    @Override
    public String getReturnTypeName() throws EGLModelException {
        SourceFunctionElementInfo info = (SourceFunctionElementInfo)this.getElementInfo();
        return Signature.createTypeSignature(info.getReturnTypeName(), false);
    }

    @Override
    public String getSignature() throws EGLModelException {
        SourceFunctionElementInfo info = (SourceFunctionElementInfo)this.getElementInfo();
        return info.getSignature();
    }

    @Override
    public boolean isSimilar(IFunction method) {
        return this.areSimilarFunctions(this.getElementName(), this.getParameterTypes(), method.getElementName(), method.getParameterTypes(), null);
    }

    @Override
    public String readableName() {
        int length;
        StringBuffer buffer = new StringBuffer(super.readableName());
        buffer.append('(');
        String[] parameterTypes = this.getParameterTypes();
        if (parameterTypes != null && (length = parameterTypes.length) > 0) {
            int i = 0;
            while (i < length) {
                buffer.append(Signature.toString(parameterTypes[i]));
                if (i < length - 1) {
                    buffer.append(", ");
                }
                ++i;
            }
        }
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            buffer.append(this.getElementName());
            buffer.append(" (not open)");
        } else if (info == NO_INFO) {
            buffer.append(this.getElementName());
        } else {
            try {
                int length;
                if (Flags.isStatic(this.getFlags())) {
                    buffer.append("static ");
                }
                buffer.append(this.getElementName());
                buffer.append('(');
                String[] parameterTypes = this.getParameterTypes();
                if (parameterTypes != null && (length = parameterTypes.length) > 0) {
                    int i = 0;
                    while (i < length) {
                        buffer.append(Signature.toString(parameterTypes[i]));
                        if (i < length - 1) {
                            buffer.append(", ");
                        }
                        ++i;
                    }
                }
                buffer.append(')');
            }
            catch (EGLModelException eGLModelException) {
                buffer.append("<EGLModelException in toString of " + this.getElementName());
            }
        }
    }

    @Override
    public String[] getUseTypes() throws EGLModelException {
        SourceFunctionElementInfo info = (SourceFunctionElementInfo)this.getElementInfo();
        char[][] useTypes = info.getUseTypes();
        if (useTypes == null || useTypes.length == 0) {
            return fgEmptyList;
        }
        String[] strings = new String[useTypes.length];
        int i = 0;
        while (i < useTypes.length) {
            strings[i] = new String(useTypes[i]);
            ++i;
        }
        return strings;
    }

    @Override
    public boolean[] getNullable() throws EGLModelException {
        SourceFunctionElementInfo info = (SourceFunctionElementInfo)this.getElementInfo();
        boolean[] areNullable = info.getAreNullable();
        return areNullable;
    }

    @Override
    public String[] getParameterPackages() throws EGLModelException {
        SourceFunctionElementInfo info = (SourceFunctionElementInfo)this.getElementInfo();
        char[][] parameterPkgs = info.getArgumentPackages();
        if (parameterPkgs == null || parameterPkgs.length == 0) {
            return fgEmptyList;
        }
        String[] strings = new String[parameterPkgs.length];
        int i = 0;
        while (i < parameterPkgs.length) {
            strings[i] = new String(parameterPkgs[i]);
            ++i;
        }
        return strings;
    }

    @Override
    public String getReturnTypePackage() throws EGLModelException {
        SourceFunctionElementInfo info = (SourceFunctionElementInfo)this.getElementInfo();
        char[] returnTypePkgs = info.getReturnTypePkg();
        if (returnTypePkgs == null) {
            return null;
        }
        if (returnTypePkgs.length == 0) {
            return "";
        }
        String string = String.valueOf(returnTypePkgs);
        return string;
    }
}

