/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.util.ArrayList;
import org.eclipse.edt.compiler.internal.core.utils.CharOperation;
import org.eclipse.edt.ide.core.internal.model.EGLElement;
import org.eclipse.edt.ide.core.internal.model.NameLookup;
import org.eclipse.edt.ide.core.internal.model.WorkingCopy;
import org.eclipse.edt.ide.core.internal.model.codeassist.SelectionEngine;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IField;
import org.eclipse.edt.ide.core.model.IFunction;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.Signature;

public class SelectionRequestor {
    public static boolean DEBUG = false;
    protected NameLookup fNameLookup = null;
    protected IEGLElement fCodeResolve;
    protected IEGLElement[] fElements = fgEmptyElements;
    protected static IEGLElement[] fgEmptyElements = new IEGLElement[0];

    public SelectionRequestor(NameLookup nameLookup, IEGLElement codeResolve) {
        this.fNameLookup = nameLookup;
        this.fCodeResolve = codeResolve;
    }

    protected void acceptBinaryMethod(IPart type, char[] selector, char[][] parameterPackageNames, char[][] parameterPartNames) {
        IFunction method;
        String[] parameterParts = null;
        if (parameterPartNames != null) {
            parameterParts = new String[parameterPartNames.length];
            int i = 0;
            int max = parameterPartNames.length;
            while (i < max) {
                String typeName;
                String pkg = "";
                if (parameterPackageNames[i] != null && parameterPackageNames[i].length > 0) {
                    pkg = String.valueOf(new String(parameterPackageNames[i])) + ".";
                }
                if ((typeName = new String(parameterPartNames[i])).indexOf(46) > 0) {
                    typeName = typeName.replace('.', '$');
                }
                parameterParts[i] = Signature.createTypeSignature(String.valueOf(pkg) + typeName, true);
                ++i;
            }
        }
        if ((method = type.getFunction(new String(selector), parameterParts)).exists()) {
            this.fElements = this.growAndAddToArray(this.fElements, method);
            if (DEBUG) {
                System.out.print("SELECTION - accept method(");
                System.out.print(method.toString());
                System.out.println(")");
            }
        }
    }

    public void acceptPart(char[] packageName, char[] className, boolean needQualification) {
        this.acceptPart(packageName, className, 4, needQualification);
    }

    public void acceptField(char[] declaringPartPackageName, char[] declaringPartName, char[] name) {
        IField field;
        IPart type = this.resolvePart(declaringPartPackageName, declaringPartName, 4);
        if (type != null && (field = type.getField(new String(name))).exists()) {
            this.fElements = this.growAndAddToArray(this.fElements, field);
            if (DEBUG) {
                System.out.print("SELECTION - accept field(");
                System.out.print(field.toString());
                System.out.println(")");
            }
        }
    }

    public void acceptFunction(char[] declaringPartPackageName, char[] declaringPartName, char[] selector, char[][] parameterPackageNames, char[][] parameterPartNames, boolean isConstructor) {
        IPart type = this.resolvePart(declaringPartPackageName, declaringPartName, 4);
        if (type != null) {
            this.acceptSourceFunction(type, selector, parameterPackageNames, parameterPartNames);
        }
    }

    public void acceptPackage(char[] packageName) {
        IPackageFragment[] pkgs = this.fNameLookup.findPackageFragments(new String(packageName), false);
        if (pkgs != null) {
            int i = 0;
            int length = pkgs.length;
            while (i < length) {
                this.fElements = this.growAndAddToArray(this.fElements, pkgs[i]);
                if (DEBUG) {
                    System.out.print("SELECTION - accept package(");
                    System.out.print(pkgs[i].toString());
                    System.out.println(")");
                }
                ++i;
            }
        }
    }

    protected void acceptSourceFunction(IPart type, char[] selector, char[][] parameterPackageNames, char[][] parameterPartNames) {
        int i;
        String name = new String(selector);
        IFunction[] methods = null;
        IEGLElement[] matches = new IEGLElement[]{};
        try {
            methods = type.getFunctions();
            i = 0;
            while (i < methods.length) {
                if (methods[i].getElementName().equals(name) && methods[i].getParameterTypes().length == parameterPartNames.length) {
                    matches = this.growAndAddToArray(matches, methods[i]);
                }
                ++i;
            }
        }
        catch (EGLModelException eGLModelException) {
            return;
        }
        if (matches.length == 0) {
            this.fElements = this.growAndAddToArray(this.fElements, type);
            if (DEBUG) {
                System.out.print("SELECTION - accept type(");
                System.out.print(type.toString());
                System.out.println(")");
            }
            return;
        }
        if (matches.length == 1) {
            this.fElements = this.growAndAddToArray(this.fElements, matches[0]);
            if (DEBUG) {
                System.out.print("SELECTION - accept method(");
                System.out.print(matches[0].toString());
                System.out.println(")");
            }
            return;
        }
        i = 0;
        while (i < matches.length) {
            IFunction method = (IFunction)matches[i];
            String[] signatures = method.getParameterTypes();
            boolean match = true;
            int p = 0;
            while (p < signatures.length) {
                char[] simpleParameterName;
                String simpleName = Signature.getSimpleName(Signature.toString(signatures[p]));
                if (!simpleName.equals(new String(simpleParameterName = CharOperation.lastSegment((char[])parameterPartNames[p], (char)'.')))) {
                    match = false;
                    break;
                }
                ++p;
            }
            if (match) {
                this.fElements = this.growAndAddToArray(this.fElements, method);
                if (SelectionEngine.DEBUG) {
                    System.out.print("SELECTION - accept method(");
                    System.out.print(method.toString());
                    System.out.println(")");
                }
            }
            ++i;
        }
    }

    protected void acceptPart(char[] packageName, char[] typeName, int acceptFlags, boolean needQualification) {
        IPart type = this.resolvePart(packageName, typeName, acceptFlags);
        if (type != null) {
            this.fElements = this.growAndAddToArray(this.fElements, type);
            if (DEBUG) {
                System.out.print("SELECTION - accept type(");
                System.out.print(type.toString());
                System.out.println(")");
            }
        }
    }

    public IEGLElement[] getElements() {
        return this.fElements;
    }

    protected IEGLElement[] growAndAddToArray(IEGLElement[] array, IEGLElement addition) {
        IEGLElement[] old = array;
        array = new IEGLElement[old.length + 1];
        System.arraycopy(old, 0, array, 0, old.length);
        array[old.length] = addition;
        return array;
    }

    protected IPart resolvePart(char[] packageName, char[] typeName, int acceptFlags) {
        IEGLElement type = null;
        if (this.fCodeResolve instanceof WorkingCopy) {
            WorkingCopy wc = (WorkingCopy)this.fCodeResolve;
            try {
                if ((packageName == null || packageName.length == 0) && wc.getPackageDeclarations().length == 0 || packageName != null && packageName.length != 0 && wc.getPackageDeclaration(new String(packageName)).exists()) {
                    char[][] compoundName = CharOperation.splitOn((char)'.', (char[])typeName);
                    if (compoundName.length > 0) {
                        type = wc.getPart(new String(compoundName[0]));
                        int i = 1;
                        int length = compoundName.length;
                        while (i < length) {
                            type = type.getPart(new String(compoundName[i]));
                            ++i;
                        }
                    }
                    if (type != null && !type.exists()) {
                        type = null;
                    }
                }
            }
            catch (EGLModelException eGLModelException) {
                type = null;
            }
        }
        if (type == null) {
            IPackageFragment[] pkgs = this.fNameLookup.findPackageFragments(packageName == null || packageName.length == 0 ? "" : new String(packageName), false);
            int i = 0;
            int length = pkgs == null ? 0 : pkgs.length;
            while (i < length) {
                type = this.fNameLookup.findPart(new String(typeName), pkgs[i], false, acceptFlags);
                if (type != null) break;
                ++i;
            }
            if (type == null) {
                String pName = "";
                if (packageName != null) {
                    pName = new String(packageName);
                }
                if (this.fCodeResolve != null && this.fCodeResolve.getParent().getElementName().equals(pName)) {
                    String tName = new String(typeName);
                    tName = tName.replace('.', '$');
                    IPart[] allParts = null;
                    try {
                        ArrayList list = ((EGLElement)this.fCodeResolve).getChildrenOfType(8);
                        allParts = new IPart[list.size()];
                        list.toArray(allParts);
                    }
                    catch (EGLModelException eGLModelException) {
                        return null;
                    }
                }
            }
        }
        return type;
    }
}

