/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.edt.compiler.tools.IRUtils;
import org.eclipse.edt.ide.core.internal.model.ClassFile;
import org.eclipse.edt.ide.core.internal.model.EGLElementInfo;
import org.eclipse.edt.ide.core.internal.model.EGLModelManager;
import org.eclipse.edt.ide.core.internal.model.EglarPackageFragmentInfo;
import org.eclipse.edt.ide.core.internal.model.EglarPackageFragmentRoot;
import org.eclipse.edt.ide.core.internal.model.EglarPackageFragmentRootInfo;
import org.eclipse.edt.ide.core.internal.model.OpenableElementInfo;
import org.eclipse.edt.ide.core.internal.model.PackageFragment;
import org.eclipse.edt.ide.core.internal.model.PackageFragmentRoot;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IClassFile;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;

public class EglarPackageFragment
extends PackageFragment {
    protected EglarPackageFragment(PackageFragmentRoot root, String name) {
        super((IPackageFragmentRoot)root, name);
    }

    protected EglarPackageFragment(PackageFragmentRoot root, String[] names) {
        super(root, names);
    }

    @Override
    protected void buildStructure(OpenableElementInfo info, IProgressMonitor monitor) throws EGLModelException {
        EglarPackageFragmentRoot root = (EglarPackageFragmentRoot)this.getParent();
        EglarPackageFragmentRootInfo parentInfo = (EglarPackageFragmentRootInfo)root.getElementInfo();
        ArrayList[] entries = (ArrayList[])parentInfo.rawPackageInfo.get(this.names);
        if (entries == null) {
            throw this.newNotPresentException();
        }
        EglarPackageFragmentInfo fragInfo = (EglarPackageFragmentInfo)info;
        fragInfo.setChildren(this.computeChildren(entries[0]));
        fragInfo.setNonEGLResources(this.computeNonJavaResources(entries[1]));
        EGLModelManager.getEGLModelManager().putInfo(this, info);
    }

    private IEGLElement[] computeChildren(ArrayList namesWithoutExtension) {
        int size = namesWithoutExtension.size();
        if (size == 0) {
            return NO_ELEMENTS;
        }
        IEGLElement[] children = new IEGLElement[size];
        int i = 0;
        while (i < size) {
            String nameWithoutExtension = (String)namesWithoutExtension.get(i);
            children[i] = new ClassFile(this, nameWithoutExtension);
            ++i;
        }
        return children;
    }

    private Object[] computeNonJavaResources(ArrayList entryNames) {
        int length = entryNames.size();
        if (length == 0) {
            return EGLElementInfo.NO_NON_EGL_RESOURCES;
        }
        ArrayList topJarEntries = new ArrayList();
        return topJarEntries.toArray(new Object[topJarEntries.size()]);
    }

    @Override
    protected OpenableElementInfo createElementInfo() {
        return new EglarPackageFragmentInfo();
    }

    public Object[] getNonJavaResources() throws EGLModelException {
        if (this.isDefaultPackage()) {
            return EGLElementInfo.NO_NON_EGL_RESOURCES;
        }
        return this.storedNonJavaResources();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    protected Object[] storedNonJavaResources() throws EGLModelException {
        return ((EglarPackageFragmentInfo)this.getElementInfo()).getNonJavaResources();
    }

    @Override
    protected boolean resourceExists() {
        if (this.fParent instanceof EglarPackageFragmentRoot) {
            return ((EglarPackageFragmentRoot)this.fParent).resourceExists();
        }
        return super.resourceExists();
    }

    @Override
    public IClassFile getClassFile(String name) {
        if (!IRUtils.isEGLIRFileName((String)name)) {
            throw new IllegalArgumentException();
        }
        try {
            EGLElementInfo openableInfo = (EGLElementInfo)this.getElementInfo();
            IEGLElement[] elements = openableInfo.getChildren();
            int i = 0;
            while (i < elements.length) {
                if (elements[i].getElementName().equals(name)) {
                    return (IClassFile)elements[i];
                }
                ++i;
            }
        }
        catch (EGLModelException eGLModelException) {}
        return super.getClassFile(name);
    }

    @Override
    public IClassFile[] getClassFiles() throws EGLModelException {
        ArrayList list = this.getChildrenOfType(7);
        IClassFile[] array = new IClassFile[list.size()];
        list.toArray(array);
        return array;
    }
}

