/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.ide.core.internal.model.OpenableElementInfo;

public class EGLModelInfo
extends OpenableElementInfo {
    Object[] nonEGLResources;

    protected EGLModelInfo() {
    }

    private Object[] computeNonEGLResources() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int length = projects.length;
        Object[] nonEGLResources = null;
        int index = 0;
        int i = 0;
        while (i < length) {
            IProject project = projects[i];
            if (!EGLProject.hasEGLNature(project)) {
                if (nonEGLResources == null) {
                    nonEGLResources = new Object[length];
                }
                nonEGLResources[index++] = project;
            }
            ++i;
        }
        if (index == 0) {
            return NO_NON_EGL_RESOURCES;
        }
        if (index < length) {
            Object[] objectArray = nonEGLResources;
            nonEGLResources = new Object[index];
            System.arraycopy(objectArray, 0, nonEGLResources, 0, index);
        }
        return nonEGLResources;
    }

    Object[] getNonEGLResources() {
        Object[] nonEGLResources = this.nonEGLResources;
        if (nonEGLResources == null) {
            nonEGLResources = this.computeNonEGLResources();
            this.nonEGLResources = nonEGLResources;
        }
        return nonEGLResources;
    }
}

