/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.ide.core.internal.model.EGLModelResources;
import org.eclipse.edt.ide.core.internal.model.EGLModelStatus;
import org.eclipse.edt.ide.core.internal.model.MultiOperation;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IOpenable;
import org.eclipse.edt.ide.core.model.IPackageFragment;

public class DeleteResourceElementsOperation
extends MultiOperation {
    protected DeleteResourceElementsOperation(IEGLElement[] elementsToProcess, boolean force) {
        super(elementsToProcess, force);
    }

    private void deletePackageFragment(IPackageFragment frag) throws EGLModelException {
        IResource res = frag.getResource();
        if (res != null && res.getType() == 2) {
            IResource fragResource;
            IResource[] remainingFiles;
            IEGLElement[] childrenOfInterest = frag.getChildren();
            if (childrenOfInterest.length > 0) {
                IResource[] resources = new IResource[childrenOfInterest.length];
                int i = 0;
                while (i < childrenOfInterest.length) {
                    resources[i] = childrenOfInterest[i].getCorrespondingResource();
                    ++i;
                }
                this.deleteResources(resources, this.fForce);
            }
            Object[] nonEGLResources = frag.getNonEGLResources();
            int actualResourceCount = 0;
            int i = 0;
            int max = nonEGLResources.length;
            while (i < max) {
                if (nonEGLResources[i] instanceof IResource) {
                    ++actualResourceCount;
                }
                ++i;
            }
            IResource[] actualNonJavaResources = new IResource[actualResourceCount];
            int i2 = 0;
            int max2 = nonEGLResources.length;
            int index = 0;
            while (i2 < max2) {
                if (nonEGLResources[i2] instanceof IResource) {
                    actualNonJavaResources[index++] = (IResource)nonEGLResources[i2];
                }
                ++i2;
            }
            this.deleteResources(actualNonJavaResources, this.fForce);
            try {
                remainingFiles = ((IFolder)res).members();
            }
            catch (CoreException ce) {
                throw new EGLModelException(ce);
            }
            boolean isEmpty = true;
            int i3 = 0;
            int length = remainingFiles.length;
            while (i3 < length) {
                IResource file = remainingFiles[i3];
                if (file instanceof IFile) {
                    this.deleteResource(file, 3);
                } else if (!file.equals((Object)res)) {
                    isEmpty = false;
                }
                ++i3;
            }
            if (isEmpty && !frag.isDefaultPackage() && (fragResource = frag.getResource()) != null) {
                this.deleteEmptyPackageFragment(frag, false, (IResource)fragResource.getParent());
            }
        }
    }

    @Override
    protected String getMainTaskName() {
        return EGLModelResources.operationDeleteResourceProgress;
    }

    @Override
    protected void processElement(IEGLElement element) throws EGLModelException {
        switch (element.getElementType()) {
            case 6: 
            case 7: {
                this.deleteResource(element.getResource(), this.fForce ? 3 : 2);
                break;
            }
            case 4: {
                this.deletePackageFragment((IPackageFragment)element);
                break;
            }
            default: {
                throw new EGLModelException(new EGLModelStatus(967, element));
            }
        }
        if (element instanceof IOpenable) {
            ((IOpenable)((Object)element)).close();
        }
    }

    @Override
    protected void verify(IEGLElement element) throws EGLModelException {
        IResource resource;
        int type;
        if (element == null || !element.exists()) {
            this.error(969, element);
        }
        if ((type = element.getElementType()) <= 3 || type > 6) {
            this.error(967, element);
        }
        if ((resource = element.getResource()) instanceof IFolder && resource.isLinked()) {
            this.error(995, element);
        }
    }
}

