/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.ide.core.internal.model.EGLModelOperation;
import org.eclipse.edt.ide.core.internal.model.EGLModelResources;
import org.eclipse.edt.ide.core.internal.model.EGLModelStatus;
import org.eclipse.edt.ide.core.internal.model.EGLPathEntry;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLModelStatus;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;

public class CopyPackageFragmentRootOperation
extends EGLModelOperation {
    IPath destination;
    int updateResourceFlags;
    int updateModelFlags;
    IEGLPathEntry sibling;

    public CopyPackageFragmentRootOperation(IPackageFragmentRoot root, IPath destination, int updateResourceFlags, int updateModelFlags, IEGLPathEntry sibling) {
        super(root);
        this.destination = destination;
        this.updateResourceFlags = updateResourceFlags;
        this.updateModelFlags = updateModelFlags;
        this.sibling = sibling;
    }

    @Override
    protected void executeOperation() throws EGLModelException {
        IPackageFragmentRoot root = (IPackageFragmentRoot)this.getElementToProcess();
        IEGLPathEntry rootEntry = root.getRawEGLPathEntry();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (!root.isExternal() && (this.updateModelFlags & 1) == 0) {
            this.copyResource(root, rootEntry, workspaceRoot);
        }
        if ((this.updateModelFlags & 8) != 0) {
            this.addEntryToEGLPath(rootEntry, workspaceRoot);
        }
    }

    protected void copyResource(IPackageFragmentRoot root, IEGLPathEntry rootEntry, final IWorkspaceRoot workspaceRoot) throws EGLModelException {
        char[][] exclusionPatterns = ((EGLPathEntry)rootEntry).fullExclusionPatternChars();
        IResource rootResource = root.getResource();
        if (root.getKind() == 2 || exclusionPatterns == null) {
            try {
                if ((this.updateModelFlags & 0x10) != 0) {
                    if (rootEntry.getPath().equals((Object)this.destination)) {
                        return;
                    }
                    IResource destRes = workspaceRoot.findMember(this.destination);
                    if (destRes != null) {
                        destRes.delete(this.updateResourceFlags, this.fMonitor);
                    }
                }
                rootResource.copy(this.destination, this.updateResourceFlags, this.fMonitor);
            }
            catch (CoreException e) {
                throw new EGLModelException(e);
            }
        }
        final int sourceSegmentCount = rootEntry.getPath().segmentCount();
        final IFolder destFolder = workspaceRoot.getFolder(this.destination);
        final IPath[] nestedFolders = this.getNestedFolders(root);
        IResourceProxyVisitor visitor = new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                IResource destRes;
                if (proxy.getType() == 2) {
                    IResource destRes2;
                    IPath path = proxy.requestFullPath();
                    if (CopyPackageFragmentRootOperation.this.prefixesOneOf(path, nestedFolders)) {
                        if (CopyPackageFragmentRootOperation.this.equalsOneOf(path, nestedFolders)) {
                            return false;
                        }
                        IFolder folder = destFolder.getFolder(path.removeFirstSegments(sourceSegmentCount));
                        if ((CopyPackageFragmentRootOperation.this.updateModelFlags & 0x10) != 0 && folder.exists()) {
                            return true;
                        }
                        folder.create(CopyPackageFragmentRootOperation.this.updateResourceFlags, true, CopyPackageFragmentRootOperation.this.fMonitor);
                        return true;
                    }
                    IPath destPath = CopyPackageFragmentRootOperation.this.destination.append(path.removeFirstSegments(sourceSegmentCount));
                    if ((CopyPackageFragmentRootOperation.this.updateModelFlags & 0x10) != 0 && (destRes2 = workspaceRoot.findMember(destPath)) != null) {
                        destRes2.delete(CopyPackageFragmentRootOperation.this.updateResourceFlags, CopyPackageFragmentRootOperation.this.fMonitor);
                    }
                    proxy.requestResource().copy(destPath, CopyPackageFragmentRootOperation.this.updateResourceFlags, CopyPackageFragmentRootOperation.this.fMonitor);
                    return false;
                }
                IPath path = proxy.requestFullPath();
                IPath destPath = CopyPackageFragmentRootOperation.this.destination.append(path.removeFirstSegments(sourceSegmentCount));
                if ((CopyPackageFragmentRootOperation.this.updateModelFlags & 0x10) != 0 && (destRes = workspaceRoot.findMember(destPath)) != null) {
                    destRes.delete(CopyPackageFragmentRootOperation.this.updateResourceFlags, CopyPackageFragmentRootOperation.this.fMonitor);
                }
                proxy.requestResource().copy(destPath, CopyPackageFragmentRootOperation.this.updateResourceFlags, CopyPackageFragmentRootOperation.this.fMonitor);
                return false;
            }
        };
        try {
            rootResource.accept(visitor, 0);
        }
        catch (CoreException e) {
            throw new EGLModelException(e);
        }
        this.setAttribute("hasModifiedResource", "true");
    }

    protected void addEntryToEGLPath(IEGLPathEntry rootEntry, IWorkspaceRoot workspaceRoot) throws EGLModelException {
        IEGLPathEntry newEntry;
        int position;
        IProject destProject = workspaceRoot.getProject(this.destination.segment(0));
        IEGLProject jProject = EGLCore.create(destProject);
        IEGLPathEntry[] EGLPath = jProject.getRawEGLPath();
        int length = EGLPath.length;
        if ((this.updateModelFlags & 0x10) != 0) {
            int i = 0;
            while (i < length) {
                if (this.destination.equals((Object)EGLPath[i].getPath())) {
                    IEGLPathEntry[] newEGLPath = new IEGLPathEntry[length];
                    System.arraycopy(EGLPath, 0, newEGLPath, 0, length);
                    newEGLPath[i] = this.copy(rootEntry);
                    jProject.setRawEGLPath(newEGLPath, this.fMonitor);
                    return;
                }
                ++i;
            }
        }
        if (this.sibling == null) {
            position = length;
        } else {
            position = -1;
            int i = 0;
            while (i < length) {
                if (this.sibling.equals(EGLPath[i])) {
                    position = i;
                    break;
                }
                ++i;
            }
        }
        if (position == -1) {
            throw new EGLModelException(new EGLModelStatus(993, this.sibling.toString()));
        }
        IEGLPathEntry[] newEGLPath = new IEGLPathEntry[length + 1];
        if (position != 0) {
            System.arraycopy(EGLPath, 0, newEGLPath, 0, position);
        }
        if (position != length) {
            System.arraycopy(EGLPath, position, newEGLPath, position + 1, length - position);
        }
        newEGLPath[position] = newEntry = this.copy(rootEntry);
        jProject.setRawEGLPath(newEGLPath, this.fMonitor);
    }

    protected IEGLPathEntry copy(IEGLPathEntry entry) throws EGLModelException {
        switch (entry.getEntryKind()) {
            case 5: {
                return EGLCore.newContainerEntry(entry.getPath(), entry.isExported());
            }
            case 1: {
                return EGLCore.newLibraryEntry(this.destination, entry.getSourceAttachmentPath(), entry.getSourceAttachmentRootPath(), entry.isExported());
            }
            case 2: {
                return EGLCore.newProjectEntry(entry.getPath(), entry.isExported());
            }
            case 3: {
                return EGLCore.newSourceEntry(this.destination, entry.getExclusionPatterns(), entry.getOutputLocation());
            }
            case 4: {
                return EGLCore.newVariableEntry(entry.getPath(), entry.getSourceAttachmentPath(), entry.getSourceAttachmentRootPath(), entry.isExported());
            }
        }
        throw new EGLModelException(new EGLModelStatus(969, this.getElementToProcess()));
    }

    @Override
    public IEGLModelStatus verify() {
        IEGLModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)this.getElementToProcess();
        if (root == null || !root.exists()) {
            return new EGLModelStatus(969, root);
        }
        IResource resource = root.getResource();
        if (resource instanceof IFolder && resource.isLinked()) {
            return new EGLModelStatus(995, root);
        }
        if ((this.updateModelFlags & 8) != 0) {
            String destProjectName = this.destination.segment(0);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(destProjectName);
            if (EGLProject.hasEGLNature(project)) {
                try {
                    IEGLProject destProject = EGLCore.create(project);
                    IEGLPathEntry[] destEGLPath = destProject.getRawEGLPath();
                    boolean foundSibling = false;
                    boolean foundExistingEntry = false;
                    int i = 0;
                    int length = destEGLPath.length;
                    while (i < length) {
                        IEGLPathEntry entry = destEGLPath[i];
                        if (entry.equals(this.sibling)) {
                            foundSibling = true;
                            break;
                        }
                        if (entry.getPath().equals((Object)this.destination)) {
                            foundExistingEntry = true;
                        }
                        ++i;
                    }
                    if (this.sibling != null && !foundSibling) {
                        return new EGLModelStatus(993, this.sibling == null ? "null" : this.sibling.toString());
                    }
                    if (foundExistingEntry && (this.updateModelFlags & 0x10) == 0) {
                        return new EGLModelStatus(977, EGLModelResources.bind((String)EGLModelResources.statusNameCollision, (Object)this.destination.toString()));
                    }
                }
                catch (EGLModelException e) {
                    return e.getEGLModelStatus();
                }
            }
        }
        return EGLModelStatus.VERIFIED_OK;
    }
}

