/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.util.ArrayList;
import org.eclipse.edt.ide.core.internal.model.Assert;
import org.eclipse.edt.ide.core.internal.model.BinaryField;
import org.eclipse.edt.ide.core.internal.model.BinaryFunction;
import org.eclipse.edt.ide.core.internal.model.BinaryMember;
import org.eclipse.edt.ide.core.internal.model.BinaryPropertyBlock;
import org.eclipse.edt.ide.core.internal.model.SourcePartElementInfo;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IField;
import org.eclipse.edt.ide.core.model.IFunction;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.IProperty;
import org.eclipse.edt.ide.core.model.IUseDeclaration;
import org.eclipse.edt.mof.utils.NameUtile;

public class BinaryPart
extends BinaryMember
implements IPart {
    private static final IField[] NO_FIELDS = new IField[0];
    private static final IFunction[] NO_FUNCTIONS = new IFunction[0];
    private static final IPart[] NO_PARTS = new IPart[0];
    protected static final String[] fgEmptyList = new String[0];
    protected static final IProperty[] fgEmptyProperties = new IProperty[0];

    protected BinaryPart(int type, IEGLElement parent, String name) {
        super(type, parent, name);
    }

    protected BinaryPart(IEGLElement parent, String name) {
        super(8, parent, name);
        Assert.isTrue(name.indexOf(46) == -1);
    }

    @Override
    public IFunction[] findFunctions(IFunction function) {
        try {
            return this.findFunctions(function, this.getFunctions());
        }
        catch (EGLModelException eGLModelException) {
            return null;
        }
    }

    @Override
    public IField getField(String name) {
        return new BinaryField(this, name);
    }

    @Override
    public IField[] getFields() throws EGLModelException {
        ArrayList list = this.getChildrenOfType(9);
        if (list.size() == 0) {
            return NO_FIELDS;
        }
        IField[] array = new IField[list.size()];
        list.toArray(array);
        return array;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.getFullyQualifiedName(':');
    }

    public String getTypeQualifiedName(char partSeparator) {
        if (this.fParent.getElementType() == 7) {
            return this.fName;
        }
        return String.valueOf(((IPart)this.fParent).getFullyQualifiedName(partSeparator)) + partSeparator + this.fName;
    }

    @Override
    public String getFullyQualifiedName(char enclosingTypeSeparator) {
        String packageName = this.getPackageFragment().getElementName();
        if (packageName.equals("")) {
            return this.getTypeQualifiedName(enclosingTypeSeparator);
        }
        String typeQualifiedName = this.getTypeQualifiedName(enclosingTypeSeparator);
        if (typeQualifiedName.startsWith(packageName)) {
            return typeQualifiedName;
        }
        return String.valueOf(packageName) + '.' + this.getTypeQualifiedName(enclosingTypeSeparator);
    }

    @Override
    public IFunction getFunction(String name, String[] parameterTypeSignatures) {
        return new BinaryFunction(this, name, parameterTypeSignatures);
    }

    @Override
    public IFunction[] getFunctions() throws EGLModelException {
        ArrayList list = this.getChildrenOfType(10);
        if (list.size() == 0) {
            return NO_FUNCTIONS;
        }
        IFunction[] array = new IFunction[list.size()];
        list.toArray(array);
        return array;
    }

    @Override
    public String[] getImplementedInterfaceNames() throws EGLModelException {
        SourcePartElementInfo info = (SourcePartElementInfo)this.getElementInfo();
        char[][] names = info.getInterfaceNames();
        if (names == null) {
            return fgEmptyList;
        }
        String[] strings = new String[names.length];
        int i = 0;
        while (i < names.length) {
            strings[i] = new String(names[i]);
            ++i;
        }
        return strings;
    }

    @Override
    public IPackageFragment getPackageFragment() {
        IEGLElement parent = this.fParent;
        while (parent != null) {
            if (parent.getElementType() == 4) {
                return (IPackageFragment)parent;
            }
            parent = parent.getParent();
        }
        Assert.isTrue(false);
        return null;
    }

    @Override
    public IPart getPart(String name) {
        return new BinaryPart(this, name);
    }

    public IPart[] getParts() throws EGLModelException {
        ArrayList list = this.getChildrenOfType(8);
        if (list.size() == 0) {
            return NO_PARTS;
        }
        IPart[] array = new IPart[list.size()];
        list.toArray(array);
        return array;
    }

    @Override
    public String getSubTypeSignature() {
        try {
            SourcePartElementInfo info = (SourcePartElementInfo)this.getElementInfo();
            return info.getSubTypeSignature();
        }
        catch (EGLModelException eGLModelException) {
            return null;
        }
    }

    @Override
    public IUseDeclaration getUseDeclaration(String name) {
        return null;
    }

    @Override
    public IUseDeclaration[] getUseDeclarations() throws EGLModelException {
        return null;
    }

    @Override
    public boolean isPublic() {
        try {
            return ((SourcePartElementInfo)this.getElementInfo()).isPublic();
        }
        catch (EGLModelException eGLModelException) {
            return false;
        }
    }

    @Override
    public boolean hasChildren() throws EGLModelException {
        return this.getChildren().length > 0;
    }

    public boolean isAnonymous() throws EGLModelException {
        return false;
    }

    public boolean isLocal() throws EGLModelException {
        return false;
    }

    public boolean isMember() throws EGLModelException {
        return this.getDeclaringPart() != null;
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            buffer.append(this.getElementName());
            buffer.append(" (not open)");
        } else if (info == NO_INFO) {
            buffer.append(this.getElementName());
        } else {
            buffer.append("part ");
            buffer.append(this.getElementName());
        }
    }

    @Override
    public IProperty[] getProperties(String key) throws EGLModelException {
        IEGLElement[] children;
        IEGLElement[] iEGLElementArray = children = this.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IEGLElement child = iEGLElementArray[n2];
            if (child instanceof BinaryPropertyBlock && ((BinaryPropertyBlock)child).getElementName().equals(key)) {
                return ((BinaryPropertyBlock)child).getProperties();
            }
            ++n2;
        }
        return null;
    }

    public boolean isProgram() {
        try {
            return ((SourcePartElementInfo)this.getElementInfo()).isProgram();
        }
        catch (EGLModelException eGLModelException) {
            return false;
        }
    }

    public boolean isSQLRecord() {
        SourcePartElementInfo part;
        block4: {
            if (!this.isRecord()) {
                return false;
            }
            try {
                part = (SourcePartElementInfo)this.getElementInfo();
                if (part.getSubTypeName() != null) break block4;
                return false;
            }
            catch (EGLModelException eGLModelException) {
                return false;
            }
        }
        return NameUtile.equals((String)NameUtile.getAsName((String)new String(part.getSubTypeName())), (String)NameUtile.getAsName((String)"SQLRecord"));
    }

    public boolean isRecord() {
        try {
            return ((SourcePartElementInfo)this.getElementInfo()).isRecord();
        }
        catch (EGLModelException eGLModelException) {
            return false;
        }
    }

    public boolean isHandler() {
        try {
            return ((SourcePartElementInfo)this.getElementInfo()).isHandler();
        }
        catch (EGLModelException eGLModelException) {
            return false;
        }
    }

    public boolean isLibrary() {
        try {
            return ((SourcePartElementInfo)this.getElementInfo()).isLibrary();
        }
        catch (EGLModelException eGLModelException) {
            return false;
        }
    }

    public boolean isFunction() {
        try {
            return ((SourcePartElementInfo)this.getElementInfo()).isFunction();
        }
        catch (EGLModelException eGLModelException) {
            return false;
        }
    }

    public boolean isService() {
        try {
            return ((SourcePartElementInfo)this.getElementInfo()).isService();
        }
        catch (EGLModelException eGLModelException) {
            return false;
        }
    }

    public boolean isInterface() {
        try {
            return ((SourcePartElementInfo)this.getElementInfo()).isInterface();
        }
        catch (EGLModelException eGLModelException) {
            return false;
        }
    }

    public boolean isDelegate() {
        try {
            return ((SourcePartElementInfo)this.getElementInfo()).isDelegate();
        }
        catch (EGLModelException eGLModelException) {
            return false;
        }
    }

    public boolean isExternalType() {
        try {
            return ((SourcePartElementInfo)this.getElementInfo()).isExternalType();
        }
        catch (EGLModelException eGLModelException) {
            return false;
        }
    }

    public boolean isEnumeration() {
        try {
            return ((SourcePartElementInfo)this.getElementInfo()).isEnumeration();
        }
        catch (EGLModelException eGLModelException) {
            return false;
        }
    }

    public boolean isClass() {
        try {
            return ((SourcePartElementInfo)this.getElementInfo()).isClass();
        }
        catch (EGLModelException eGLModelException) {
            return false;
        }
    }

    @Override
    public String[] getUsePartPackages() throws EGLModelException {
        SourcePartElementInfo info = (SourcePartElementInfo)this.getElementInfo();
        char[][] usePartPkgs = info.getUsagePartPackages();
        if (usePartPkgs == null) {
            return null;
        }
        if (usePartPkgs.length == 0) {
            return fgEmptyList;
        }
        String[] strings = new String[usePartPkgs.length];
        int i = 0;
        while (i < usePartPkgs.length) {
            if (usePartPkgs[i] != null) {
                strings[i] = new String(usePartPkgs[i]);
            }
            ++i;
        }
        return strings;
    }

    @Override
    public String[] getUsePartTypes() throws EGLModelException {
        SourcePartElementInfo info = (SourcePartElementInfo)this.getElementInfo();
        char[][] usePartTypes = info.getUsagePartTypes();
        if (usePartTypes == null) {
            return null;
        }
        if (usePartTypes.length == 0) {
            return fgEmptyList;
        }
        String[] strings = new String[usePartTypes.length];
        int i = 0;
        while (i < usePartTypes.length) {
            if (usePartTypes[i] != null) {
                strings[i] = new String(usePartTypes[i]);
            }
            ++i;
        }
        return strings;
    }
}

