/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPath;

public class ProjectBuildPathManager {
    private static ProjectBuildPathManager INSTANCE = new ProjectBuildPathManager();
    private HashMap projectBuildPathMap = new HashMap(5);

    public static ProjectBuildPathManager getInstance() {
        return INSTANCE;
    }

    private ProjectBuildPathManager() {
    }

    public ProjectBuildPath getProjectBuildPath(IProject project) {
        ProjectBuildPath prjBuildPath = (ProjectBuildPath)this.projectBuildPathMap.get(project);
        if (prjBuildPath == null) {
            prjBuildPath = new ProjectBuildPath(project);
            this.projectBuildPathMap.put(project, prjBuildPath);
        }
        return prjBuildPath;
    }

    public void clear(IProject project) {
        ProjectBuildPath prjBuildPath = (ProjectBuildPath)this.projectBuildPathMap.get(project);
        if (prjBuildPath != null) {
            prjBuildPath.clear();
        }
    }

    public void remove(IProject project) {
        this.projectBuildPathMap.remove(project);
    }

    protected void clearAll() {
        this.projectBuildPathMap.clear();
    }

    public int getCount() {
        return this.projectBuildPathMap.size();
    }
}

