/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.generation;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.edt.ide.core.CoreIDEPluginStrings;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.Logger;
import org.eclipse.edt.ide.core.generation.IGenerationUnit;
import org.eclipse.edt.ide.core.internal.generation.CommandFile;
import org.eclipse.edt.ide.core.internal.generation.GenerateCommandFileRequest;
import org.eclipse.edt.ide.core.internal.generation.IEGLPartWrapper;
import org.eclipse.edt.ide.core.internal.generation.PartWrapper;
import org.eclipse.edt.ide.core.internal.utils.ProjectPathUtility;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GenerateCommandFileOperation {
    public static final String EGL_COMMAND_FILE_EXTENSION = "xml";
    private static final GenerateCommandFileOperation generateCmdFileOperation = new GenerateCommandFileOperation();
    private static ArrayList commandFileRequestList = new ArrayList();

    private GenerateCommandFileOperation() {
    }

    public static GenerateCommandFileOperation getInstance() {
        return generateCmdFileOperation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IGenerationUnit[] parts, String cmdFilePath, IProject[] projects, boolean createEGLPath) {
        GenerateCommandFileRequest request = new GenerateCommandFileRequest(parts, cmdFilePath, projects, createEGLPath);
        ArrayList arrayList = commandFileRequestList;
        synchronized (arrayList) {
            commandFileRequestList.add(request);
        }
        Job generationJob = this.createGenerationJob();
        generationJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateCommandFile(IProgressMonitor monitor) {
        GenerateCommandFileOperation generateCommandFileOperation = generateCmdFileOperation;
        synchronized (generateCommandFileOperation) {
            GenerateCommandFileRequest request = null;
            IGenerationUnit[] partList = null;
            ArrayList arrayList = commandFileRequestList;
            synchronized (arrayList) {
                if (commandFileRequestList.size() > 0) {
                    request = (GenerateCommandFileRequest)commandFileRequestList.remove(0);
                }
            }
            if (request != null) {
                CommandFileGenerator createCommand = new CommandFileGenerator(request.getEglCommandFilePath());
                if (request.isCreateEGLPath()) {
                    createCommand.setEGLPath(ProjectPathUtility.getEglPathString(request.getProjects()));
                }
                partList = request.getGenerationUnits();
                monitor.beginTask(CoreIDEPluginStrings.GenerateCommandFileOperation_TaskName, partList.length * 2);
                int i = 0;
                while (i < partList.length) {
                    monitor.worked(1);
                    if (monitor.isCanceled()) break;
                    PartWrapper part = partList[i].getPart();
                    IEGLPartWrapper bdWrapper = partList[i].getBuildDescriptor();
                    Path partPath = new Path(part.getPartPath());
                    Path bdPath = new Path(bdWrapper.getPartPath());
                    monitor.subTask(CoreIDEPluginStrings.bind((String)CoreIDEPluginStrings.GenerateCommandFileOperation_SubTaskName, (Object)part.getPartName()));
                    createCommand.createGenerateCommand(partPath.makeRelative().toOSString(), bdPath.makeRelative().toOSString(), bdWrapper.getPartName());
                    monitor.worked(1);
                    ++i;
                }
                try {
                    createCommand.write();
                }
                catch (IOException e) {
                    Logger.log(this, "EGLGenerateCommandFileOperation.process():  Error during command file write", e);
                }
                createCommand.dispose();
                monitor.done();
            }
        }
    }

    private Job createGenerationJob() {
        Job generationJob = new Job(CoreIDEPluginStrings.GenerateCommandFileOperation_JobName){

            public IStatus run(IProgressMonitor monitor) {
                WorkspaceModifyOperation modifyOperation = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                        GenerateCommandFileOperation.this.generateCommandFile(monitor);
                    }
                };
                try {
                    modifyOperation.run(monitor);
                }
                catch (InvocationTargetException e) {
                    Logger.log((Object)this, "EGLGenerateCommandFileOperation.createGenerationJob():  InvocationTargetException", e);
                }
                catch (InterruptedException e) {
                    Logger.log((Object)this, "EGLGenerateCommandFileOperation.createGenerationJob():  InterruptedException", e);
                }
                return Status.OK_STATUS;
            }
        };
        generationJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        generationJob.setSystem(false);
        generationJob.setPriority(30);
        generationJob.setUser(true);
        return generationJob;
    }

    private class CommandFileGenerator {
        private static final String EGLCOMMANDS_EGLPATH_ATTRIBUTE = "eglpath";
        private static final String GENERATE_ELEMENT = "generate";
        private static final String GENERATE_FILE_ATTRIBUTE = "file";
        private static final String BUILD_DESCRIPTOR_ELEMENT = "buildDescriptor";
        private static final String BUILD_DESCRIPTOR_NAME_ATTRIBUTE = "name";
        private static final String BUILD_DESCRIPTOR_FILE_ATTRIBUTE = "file";
        private IDOMDocument document = null;
        private IPath path = null;
        private final String MODEL_ID = String.valueOf(EDTCoreIDEPlugin.EGL_UTILITIES) + "." + "xml";

        public CommandFileGenerator(String filePath) {
            this.setPath(filePath);
            this.initialize();
        }

        private void setPath(String filePath) {
            this.path = new Path(filePath);
            if (this.path.getFileExtension() == null) {
                this.path = this.path.addFileExtension(GenerateCommandFileOperation.EGL_COMMAND_FILE_EXTENSION);
            } else if (!this.path.getFileExtension().equalsIgnoreCase(GenerateCommandFileOperation.EGL_COMMAND_FILE_EXTENSION)) {
                this.path = this.path.addFileExtension(GenerateCommandFileOperation.EGL_COMMAND_FILE_EXTENSION);
            }
        }

        public void dispose() {
            if (this.document != null) {
                this.document.getModel().releaseFromEdit();
            }
        }

        private void initialize() {
            IModelManager modelManager = StructuredModelManager.getModelManager();
            try {
                IDOMModel xmlModel = (IDOMModel)modelManager.getModelForEdit(this.MODEL_ID, (InputStream)new ByteArrayInputStream(CommandFile.createEmptyCommandFile().getBytes()), null);
                this.document = xmlModel.getDocument();
            }
            catch (UnsupportedEncodingException e) {
                Logger.log(this, "EGLCreateCommandFileOperation.EGLCreateCommandFileCommand::initialize() - Unsupported Encoding Exception", e);
            }
            catch (IOException e) {
                Logger.log(this, "EGLCreateCommandFileOperation.EGLCreateCommandFileCommand::initialize() - IOException", e);
            }
        }

        private void setEGLPath(String path) {
            if (this.document != null) {
                this.document.getDocumentElement().setAttribute(EGLCOMMANDS_EGLPATH_ATTRIBUTE, path);
            }
        }

        public void createGenerateCommand(String partFileName, String buildDescriptorFileName, String buildDescriptorName) {
            if (this.document != null) {
                Node genElement = this.createGenerateElement(this.document.getDocumentElement(), partFileName);
                this.createBuildDescriptorElement(genElement, buildDescriptorFileName, buildDescriptorName);
            }
        }

        private Node createBuildDescriptorElement(Node parent, String buildDescriptorFileName, String buildDescriptorName) {
            Element bdElement = null;
            if (this.document != null) {
                bdElement = this.document.createElement(BUILD_DESCRIPTOR_ELEMENT);
                bdElement.setAttribute(BUILD_DESCRIPTOR_NAME_ATTRIBUTE, buildDescriptorName);
                bdElement.setAttribute("file", buildDescriptorFileName);
                parent.appendChild(bdElement);
            }
            return bdElement;
        }

        private Node createGenerateElement(Node parent, String partFileName) {
            Element genElement = null;
            if (this.document != null) {
                genElement = this.document.createElement(GENERATE_ELEMENT);
                genElement.setAttribute("file", partFileName);
                parent.appendChild(genElement);
            }
            return genElement;
        }

        public void write() throws IOException {
            if (this.document != null) {
                if (this.path.segmentCount() > 0) {
                    if (this.createDirectoryIfNecessary(this.path)) {
                        File file = this.path.toFile();
                        if (file.exists() && file.canWrite() || !file.exists() && file.createNewFile()) {
                            this.formatDocument();
                            FileOutputStream stream = new FileOutputStream(file);
                            try {
                                this.document.getModel().save((OutputStream)stream);
                            }
                            catch (UnsupportedEncodingException e) {
                                e.printStackTrace();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                            stream.close();
                        } else {
                            this.openErrorDialog();
                        }
                    } else {
                        Logger.log((Object)this, "EGLGenerateCommandFileOperation.EGLCommandFileGenerator::write() - error writing file");
                    }
                } else {
                    Logger.log((Object)this, "EGLGenerateCommandFileOperation.EGLCommandFileGenerator::write() - invalid path");
                }
            }
        }

        private void openErrorDialog() {
            Display display = Display.getDefault();
            if (display != null) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (window != null) {
                            MessageDialog.openError((Shell)window.getShell(), (String)CoreIDEPluginStrings.GenerateCommandFileOperation_ErrorMessage_Title, (String)CoreIDEPluginStrings.bind((String)CoreIDEPluginStrings.GenerateCommandFileOperation_ErrorMessage_Message, (Object)CommandFileGenerator.this.path.toOSString()));
                        }
                    }
                });
            }
        }

        private void formatDocument() {
            if (this.document != null) {
                FormatProcessorXML processor = new FormatProcessorXML();
                processor.formatModel((IStructuredModel)this.document.getModel());
            }
        }

        private boolean createDirectoryIfNecessary(IPath path) {
            boolean result = true;
            File file = null;
            if (path.segmentCount() > 0) {
                path = path.removeLastSegments(1);
            }
            if (!(file = new File(path.toOSString())).exists()) {
                result = file.mkdir();
            }
            return result;
        }
    }
}

