/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.generation;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.core.builder.IBuildNotifier;
import org.eclipse.edt.ide.core.CoreIDEPluginStrings;
import org.eclipse.edt.ide.core.internal.generation.AbstractGenerator;
import org.eclipse.edt.ide.core.internal.generation.GenerationBuilder;
import org.eclipse.edt.ide.core.internal.utils.Util;
import org.eclipse.edt.mof.utils.NameUtile;

public class CleanGenerator
extends AbstractGenerator {
    public CleanGenerator(GenerationBuilder builder, IBuildNotifier notifier) {
        super(builder, notifier);
    }

    @Override
    protected void addAdditionalParts() {
        this.notifier.subTask(CoreIDEPluginStrings.analyzingAllIRs);
        try {
            final int segmentCount = this.outputLocation.getFullPath().segmentCount();
            this.outputLocation.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    switch (proxy.getType()) {
                        case 1: {
                            IResource resource = proxy.requestResource();
                            if (!CleanGenerator.this.processedFiles.contains(resource)) {
                                IPath fullPath = resource.getFullPath();
                                IPath packagePath = fullPath.removeFirstSegments(segmentCount).removeLastSegments(1);
                                CleanGenerator.this.generationQueue.addPart(NameUtile.getAsName((String)Util.pathToQualifiedName(packagePath)), NameUtile.getAsName((String)fullPath.removeFileExtension().lastSegment()));
                            }
                            return false;
                        }
                    }
                    return true;
                }
            }, 0);
        }
        catch (CoreException e) {
            throw new BuildException((Throwable)e);
        }
    }
}

